#!/bin/sh
# Copyright 2023 AzukiAtsui

del_xml_comments() {
  # Delete xml comments.
  sed -i -e 's/[[:space:]]*<\!--.*-->[[:space:]]*//g' \
    -e '/<\!--/,/-->/c'"" "$1"
}

del_blank_lines() {
  # Delete blank lines.
  sed -i '/^[[:space:]]*$/d' "$1"
}

# Delete any content which has no important influence.
del_extra() {
  del_xml_comments "$1"
  del_blank_lines "$1"
}

del_duplicate_lines() {
  # Keep lines' first existence and delete inferior duplicate lines.
  case $1 in
  awk)
    awk '!x[$0]++' "$2" > /data/adb/AzukiAtsui/tmp.txt
    ;;
  uniq)
    uniq "$2" > /data/adb/AzukiAtsui/tmp.txt
    ;;
  *)
    ui_print "- ERROR: Unknown command in del_duplicate_lines."
    ui_print "  Try \`del_duplicate_lines awk <target>\`"
    ui_print "  or \`del_duplicate_lines uniq <target>\`."
    return 1
  esac
  clone_perm "$2" /data/adb/AzukiAtsui/tmp.txt
  mv /data/adb/AzukiAtsui/tmp.txt "$2"
}
