#!/bin/sh
# Copyright 2023 AzukiAtsui
# <AzukiAtsui@163.com>

# Skip all default installation steps.
SKIPUNZIP=1

# The time when this script started running.
START=$(date +%s)

# Artificially unzip. MODPATH is the path where
# your module files should be installed.
unzip -o "$ZIPFILE" -d "$MODPATH"\
  -x 'META-INF/*' 'customize.sh' >&2

# MODDIR is the path where this module files have been completely installed.
MODDIR=$(echo "$MODPATH" | sed 's/_update//')
INSTALLING=true

# NOT suggest to use `sh <script>` preventing functions
# and variables are NOT inherited down to child processes.
# Prefer `. <script>`.
. "$MODPATH/scripts/check-env.sh"

# <https://kernelsu.org/guide/module.html#system-directory>
# REMOVE containing a list of directories in customize.sh
# to execute removal operations, and KernelSU will automatically
# execute `mknod <TARGET> c 0 0` in the corresponding directories of the module.
#REMOVE="
#/my_product/etc/extension/feature_com.android.launcher_premium.xml
#"

main() {
  case $SYSTEMTYPE in
    oplus)
      # Support realme RealmeUI 2~4, OPPO, OnePlus ColorOS 11~13.
      . "$MOD_ROOT/scripts/oplus-mod.sh"
      main_oplus
      ;;
    *)
      ui_print "- Not support current system."
      ;;
  esac
  return 0
}

main

# Clean temp files before installation done.
rm -rf "$MODPATH/bootanimation"

# Fix versionCode bug in older Magisk Manager App.
sed -i 's/versionCode/versioncode/' "$MODPATH/module.prop"

# Some files are in the same partition, leave only one Overlay Mount command line.
del_duplicate_lines uniq "$MODPATH/post-fs-data.sh"

# Add delete backup directory shell to uninstall.sh.
echo '
# Delete backup directory.
rm -rf /data/adb/AzukiAtsui' >> "$MODPATH/uninstall.sh"

# The time when this script finished above main functions.
END=$(date +%s)
ui_print "✔ 模块安装完成。耗时：$(( END - START ))s"
ui_print "* 修改在重启后生效"

# Do not add `exit` to make sure magisk auto set works.
