mount -o rw,remount /data
MODDIR=${0%/*}

# etc
if [ -d /sbin/.magisk ]; then
  MAGISKTMP=/sbin/.magisk
else
  MAGISKTMP=`find /dev -mindepth 2 -maxdepth 2 -type d -name .magisk`
fi
ETC=$MAGISKTMP/mirror/system/etc
VETC=$MAGISKTMP/mirror/vendor/etc
VOETC=$MAGISKTMP/mirror/vendor/odm/etc
MODETC=$MODDIR/system/etc
MODVETC=$MODDIR/system/vendor/etc
MODVOETC=$MODDIR/system/vendor/odm/etc

# media profiles
FILE=*media*profiles*.xml
rm -f `find $MODDIR/system -type f -name $FILE`
MP=`find $ETC -maxdepth 1 -type f -name $FILE`
VMP=`find $VETC -maxdepth 1 -type f -name $FILE`
VOMP=`find $VOETC -maxdepth 1 -type f -name $FILE`
cp -f $MP $MODETC
cp -f $VMP $MODVETC
cp -f $VOMP $MODVOETC

# patch media profiles
MODMP=`find $MODDIR/system -type f -name $FILE`
if echo $MODMP | grep -Eq xml; then
  sed -i 's/maxFrameRate="30"/maxFrameRate="90"/g' $MODMP
  sed -i 's/maxFrameRate="48"/maxFrameRate="90"/g' $MODMP
  sed -i 's/maxFrameRate="60"/maxFrameRate="90"/g' $MODMP
fi

# dependency
rm -f /data/adb/modules/MiuiCore/remove
rm -f /data/adb/modules/MiuiCore/disable

# cleaning
FILE=$MODDIR/cleaner.sh
if [ -f $FILE ]; then
  sh $FILE
  rm -f $FILE
fi




