ui_print " "

# boot mode
if [ "$BOOTMODE" != true ]; then
  abort "- Please flash via Magisk Manager only!"
fi

# info
MODVER=`grep_prop version $MODPATH/module.prop`
MODVERCODE=`grep_prop versionCode $MODPATH/module.prop`
ui_print " ID=$MODID"
ui_print " Version=$MODVER"
ui_print " VersionCode=$MODVERCODE"
ui_print " MagiskVersion=$MAGISK_VER"
ui_print " MagiskVersionCode=$MAGISK_VER_CODE"
ui_print " "

# architecture
if [ "$ARCH" == arm64 ]; then
  ui_print "- Architecture $ARCH"
  cp -f $MODPATH/arm64-v8a/* $MODPATH/system/lib64
  cp -f $MODPATH/armeabi-v7a/* $MODPATH/system/lib
  ui_print " "
elif [ "$ARCH" == arm ]; then
  ui_print "- Architecture $ARCH"
  cp -f $MODPATH/armeabi-v7a/* $MODPATH/system/lib
  rm -rf $MODPATH/system/lib64
  ui_print " "
else
  ui_print "! Unsupported architecture $ARCH. This module is only for"
  ui_print "  arm64 and arm architectures."
  abort
fi
rm -rf $MODPATH/arm64-v8a
rm -rf $MODPATH/armeabi-v7a

# sdk
NUM=23
if [ "$API" -lt $NUM ]; then
  ui_print "! Unsupported SDK $API."
  ui_print "  You have to upgrade your Android version"
  ui_print "  at least SDK API $NUM to use this module."
  abort
else
  ui_print "- SDK $API"
  ui_print " "
fi

# miuicore
if [ ! -d /data/adb/modules_update/MiuiCore ] && [ ! -d /data/adb/modules/MiuiCore ]; then
  ui_print "! Miui Core Magisk Module is not installed."
  ui_print "  Please read github installation guide!"
  abort
else
  rm -f /data/adb/modules/MiuiCore/remove
  rm -f /data/adb/modules/MiuiCore/disable
fi

# test
APP=MiuiScreenRecorder
PKG=com.miui.screenrecorder
FILE=$MODPATH/system/priv-app/$APP/$APP.apk
ui_print "- Testing signature..."
RES=`pm install -g -i com.android.vending $FILE`
if [ $RES ]; then
  ui_print "  $RES"
fi
if [ "$RES" == Success ]; then
  RES=`pm uninstall -k $PKG`
  ui_print "  Signature test is passed"
elif [ -d /data/adb/modules_update/luckypatcher ] || [ -d /data/adb/modules/luckypatcher ]; then
  ui_print "  Enabling Patches to Android Lucky Patcher Module..."
  rm -f /data/adb/modules/luckypatcher/remove
  rm -f /data/adb/modules/luckypatcher/disable
elif echo "$RES" | grep -Eq INSTALL_FAILED_SHARED_USER_INCOMPATIBLE; then
  ui_print "  Signature test is failed"
  ui_print "  But installation is allowed for this case"
  ui_print "  Make sure you have deactivated your Android Signature"
  ui_print "  Verification or the app cannot be installed correctly."
  ui_print "  If you don't know what it is, please READ #troubleshootings."
else
  ui_print "  ! Signature test is failed"
  ui_print "    You need to disable Signature Verification of your"
  ui_print "    Android first to use this module. READ #troubleshootings!"
  abort
fi
ui_print " "

# framework.jar
APP=MiuiScreenRecorder
NAME=FOR_LOOPBACK
ui_print "- Checking $NAME in framework.jar"
ui_print "  Please wait..."
if getprop | grep -Eq "msr.alt\]: \[1" || ! grep -Eq $NAME /system/framework/framework.jar; then
  ui_print "  Using another $APP.apk"
  cp -rf $MODPATH/systemalt/* $MODPATH/system
fi
rm -rf $MODPATH/systemalt
ui_print " "

# cleaning
ui_print "- Cleaning..."
APP="MiuiScreenRecorder
     com.miui.screenrecorder"
for APPS in $APP; do
  rm -f `find /data/dalvik-cache /data/system/package_cache -type f -name *$APPS*`
done
rm -f $MODPATH/LICENSE
ui_print " "

# features
PROP=`getprop miui.features`
FILE=$MODPATH/system.prop
if [ "$PROP" == 0 ]; then
  ui_print "- Removing ro.product.name changes..."
  rm -f $FILE
  ui_print " "
elif [ "$PROP" ] && [ "$PROP" != 1 ]; then
  ui_print "- Your ro.product.name will be changed to $PROP"
  sed -i "s/cepheus/$PROP/g" $FILE
  ui_print " "
elif [ "$PROP" == 1 ]; then
  ui_print "- Your ro.product.name will be changed to cepheus"
  ui_print " "
fi

# store
clean_rules() {
  rm -f $MODPATH/sepolicy.rule
  rm -rf /metadata/magisk/$MODID
  rm -rf /mnt/vendor/persist/magisk/$MODID
  rm -rf /persist/magisk/$MODID
  rm -rf /data/unencrypted/magisk/$MODID
  rm -rf /cache/magisk/$MODID
}
permissive() {
  SELINUX=`getenforce`
  if [ "$SELINUX" == Enforcing ]; then
    setenforce 0
    SELINUX=`getenforce`
    if [ "$SELINUX" == Enforcing ]; then
      ui_print "  ! Your device can't be turned to Permissive state."
    fi
    setenforce 1
  fi
  sed -i '1i\
SELINUX=`getenforce`\
if [ "$SELINUX" == Enforcing ]; then\
  setenforce 0\
fi\' $MODPATH/post-fs-data.sh
}

# permissive
if getprop | grep -Eq "miui.permissive\]: \[1"; then
  ui_print "- Using permissive method"
  clean_rules
  permissive
  ui_print " "
elif getprop | grep -Eq "miui.permissive\]: \[2"; then
  ui_print "- Using both permissive and SE policy patch"
  permissive
  ui_print " "
fi

# permission
ui_print "- Setting permission..."
FOLDER=`find $MODPATH/system/vendor -type d`
for FOLDERS in $FOLDER; do
  chown 0.2000 $FOLDERS
done
if [ "$API" -gt 25 ]; then
  chcon -R u:object_r:vendor_file:s0 $MODPATH/system/vendor
  chcon -R u:object_r:vendor_configs_file:s0 $MODPATH/system/vendor/etc
fi
ui_print " "

# store
copy_sepolicy_rules() {
  rm -rf /data/unencrypted/magisk/* /cache/magisk/* /metadata/magisk/* /persist/magisk/* /mnt/vendor/persist/magisk/*
  mkdir /data/unencrypted/magisk /cache/magisk /metadata/magisk /persist/magisk /mnt/vendor/persist/magisk

  local RULESDIR
  local active_dir=$(magisk --path)/.magisk/mirror/sepolicy.rules
  if [ -L $active_dir ]; then
    RULESDIR=$(readlink $active_dir)
  elif [ -d /data/unencrypted ] && ! grep ' /data ' /proc/mounts | grep -qE 'dm-|f2fs'; then
    RULESDIR=/data/unencrypted/magisk
  elif grep -q ' /cache ' /proc/mounts; then
    RULESDIR=/cache/magisk
  elif grep -q ' /metadata ' /proc/mounts; then
    RULESDIR=/metadata/magisk
  elif grep -q ' /persist ' /proc/mounts; then
    RULESDIR=/persist/magisk
  elif grep -q ' /mnt/vendor/persist ' /proc/mounts; then
    RULESDIR=/mnt/vendor/persist/magisk
  else
    return
  fi

  for r in /data/adb/modules*/*/sepolicy.rule; do
    [ -f "$r" ] || continue
    local MODDIR=${r%/*}
    [ -f $MODDIR/disable ] && continue
    [ -f $MODDIR/remove ] && continue
    local MODNAME=${MODDIR##*/}
    mkdir -p $RULESDIR/$MODNAME
    cp -f $r $RULESDIR/$MODNAME/sepolicy.rule
  done
}




