MODDIR=${0%/*}

# $1:value $2:path
lock_val() {
    if [ -f "$2" ]; then
        chown root:root "$2"
        chmod 0666 "$2"
        echo "$1" >"$2"
        chmod 0444 "$2"

        touch /data/local/tmp/mount_mask_$1
        echo "$1" > /data/local/tmp/mount_mask_$1
        umount "$2"
        mount --bind /data/local/tmp/mount_mask_$1 "$2"
    fi
}

wait_until_login() {
    # in case of /data encryption is disabled
    while [ "$(getprop sys.boot_completed)" != "1" ]; do
        sleep 1
    done

    # in case of the user unlocked the screen
    while [ ! -d "/sdcard/Android" ]; do
        sleep 1
    done
}

disable_userspace_boost() {
    if [ -d /dev/migt ]; then
        chmod 0000 /dev/migt
        chmod 0000 /sys/module/migt/parameters/*
    fi

    lock_val "0" /sys/module/mtk_core_ctl/parameters/policy_enable
    lock_val "0" /sys/module/mtk_fpsgo/parameters/boost_affinity
    lock_val "0" /sys/module/fbt_cpu/parameters/boost_affinity
    lock_val "0" /sys/kernel/fpsgo/minitop/enable

    for i in $(seq 0 7); do
        lock_val "0" /sys/devices/system/cpu/cpu$i/core_ctl/enable
    done
}

wait_until_login
disable_userspace_boost

killall -15 AsoulOpt
nohup $MODDIR/AsoulOpt > /dev/null 2>&1 &
