#!/system/bin/sh

log_file="/cache/writeback.log"

export PATH="$(magisk --path)/.magisk/busybox:$PATH"

times=0

> "$log_file"

log() {
    printf "[%s] %s\n" "$(date "+%Y-%m-%d %H:%M:%S")" "$1" >> "$log_file"
}

check() {
    until [ "$times" == 5 ]; do
        app=$(dumpsys activity lru | grep 'TOP' | awk 'NR==1' | awk -F ':' '{print $3}' | awk -F '/' '{print $1}')
        if [ "$app" != "$apps" ]; then
            if [[ -z $app ]]; then
                sleep 5
            else
                log "切换前台应用：$app"
                let 'times+=1'
            fi
        fi
        apps="$app"
        sleep 10
    done
}

writeback() {
    echo ${1} > /sys/block/zram0/writeback
    times=0
}

write_data() {
    origin_data=$(cat /sys/block/zram0/bd_stat)
    old_write=$(echo ${origin_data} | awk '{print $3}')
    if [ "$writes" == 5 ]; then
        log "正在进行大回写中..."
        writes=1
        writeback "idle"
    else
        log "正在进行小回写中..."
        let 'writes+=1'
        writeback "huge"
        # 提前写入
        if [ "$writes" == 4 ]; then
            echo all > /sys/block/zram0/idle
        fi
    fi
    new_data=$(cat /sys/block/zram0/bd_stat)
    write_size=$(echo ${new_data} | awk '{print $1}')
    read_size=$(echo ${new_data} | awk '{print $2}')
    new_write=$(echo ${new_data} | awk '{print $3}')
    let write_size=${write_size}*4/1024
    let read_size=${read_size}*4/1024
    let old_write=${old_write}*4/1024
    let new_write=${new_write}*4/1024
    let delta_write=${new_write}-${old_write}
    echo "本次已写入：${delta_write}MB
已回写：${write_size}MB
总读取：${read_size}MB
总写入：${new_write}MB" >> "$log_file"
}

boot_optimization() {
    log "内存扩展回写开始运行！"
    writes=5
    sleep 30
    echo all > /sys/block/zram0/idle
    sleep 90
    write_data
}

boot_optimization

while true; do
    check
    write_data
done
