MODDIR=${0%/*}
sleep 10

#cpu负载均衡，改1为核心均衡，2为软件均衡，可能只会有部分生效，是因为系统限制
echo 1 > /dev/cpuset/sched_relax_domain_level
echo 1 > /dev/cpuset/system-background/sched_relax_domain_level
echo 1 > /dev/cpuset/background/sched_relax_domain_level
echo 1 > /dev/cpuset/camera-background/sched_relax_domain_level
echo 1 > /dev/cpuset/foreground/sched_relax_domain_level
echo 1 > /dev/cpuset/top-app/sched_relax_domain_level
echo 1 > /dev/cpuset/restricted/sched_relax_domain_level
echo 1 > /dev/cpuset/asopt/sched_relax_domain_level
echo 1 > /dev/cpuset/camera-daemon/sched_relax_domain_level
#cpu调整
echo 100 > /dev/stune/schedtune.boost
echo 100 > /dev/stune/foreground/schedtune.boost
echo 100 > /dev/stune/top-app/schedtune.boost
echo 20 > /dev/stune/background/schedtune.boost
echo 20 > /dev/stune/rt/schedtune.boost
echo 50 > /dev/stune/io/schedtune.boost
echo 50 > /dev/stune/camera-daemon/schedtune.boost
#CPU调度
chmod 644 /sys/devices/system/cpu/cpu3/cpufreq/scaling_governor
echo performance > /sys/devices/system/cpu/cpu3/cpufreq/scaling_governor
chmod 644 /sys/devices/system/cpu/cpu6/cpufreq/scaling_governor
echo performance > /sys/devices/system/cpu/cpu6/cpufreq/scaling_governor
chmod 644 /sys/devices/system/cpu/cpu7/cpufreq/scaling_governor
echo performance > /sys/devices/system/cpu/cpu7/cpufreq/scaling_governor
# 禁用 调度自动分组
echo 0 > /proc/sys/kernel/sched_autogroup_enabled
#功耗换性能
echo 1 > /sys/module/ged/parameters/gx_game_mode
echo 47 > /sys/module/ged/parameters/gx_fb_dvfs_margin
echo 1 > /sys/module/ged/parameters/enable_cpu_boost
echo 1 > /sys/module/ged/parameters/enable_gpu_boost
echo 1 > /sys/module/ged/parameters/gx_dfps
echo 1 > /sys/devices/system/cpu/cpufreq/performance/boost
echo 1 > /sys/devices/system/cpu/cpufreq/performance/max_freq_hysteresis
echo 1 > /sys/devices/system/cpu/cpufreq/performance/align_windows
echo 0 > /sys/module/adreno_idler/parameters/adreno_idler_active
echo 1 > /sys/module/msm_performance/parameters/touchboost
echo -1 > /sys/kernel/fpsgo/fbt/thrm_limit_cpu
echo -1 > /sys/kernel/fpsgo/fbt/thrm_sub_cpu

#MIUI13极致模式
settings put Secure speed_mode_enable 1
#settings put System POWER_PERFORMANCE_MODE_OPEN 1

#减轻CPU负担（停用hw叠加层）
sf=0
while :
do
if [ $sf -eq 1 ]
then
service call SurfaceFlinger 1008 i32 1
break
else
sf=$(service list | grep -c "SurfaceFlinger")
sleep 2
fi
done

#优化电池白名单
function settings()
{
    cat /sdcard/Android/battery_optimization.conf | grep -v '^#' | grep "^$1=" | cut -f2 -d '='
}

sh /data/adb/modules/CPU_set/battery_optimization.sh

#杀死部分系统进程
sh /data/adb/modules/CPU_set/kill.sh

#禁用部分调试与统计
sh /data/adb/modules/CPU_set/preliminary_test.sh

#性能
sh /data/adb/modules/CPU_set/performance.sh

function priority()
{
  echo -n "  + $1 "
  pgrep -o $1 | while read pid; do
  renice -n 5 -p $pid
  done
}

#surfaceflinger
priority surfaceflinger
#系统服务
priority system_server
#sensors
priority sensors
#pq
priority pq
#touchpan
priority touchpan
#composer
priority composer