mount /data 2>/dev/null
MODDIR=${0%/*}

# etc
if [ -d /sbin/.magisk ]; then
  MAGISKTMP=/sbin/.magisk
else
  MAGISKTMP=`find /dev -mindepth 2 -maxdepth 2 -type d -name .magisk`
fi
ETC=$MAGISKTMP/mirror/system/etc
VETC=$MAGISKTMP/mirror/vendor/etc
MODETC=$MODDIR/system/etc
MODVETC=$MODDIR/system/vendor/etc

# conflict
AML=/data/adb/modules/aml
ACDB=/data/adb/modules/acdb
if [ -d $AML ] && [ -d $ACDB ]; then
  rm -rf $ACDB
fi

# audio effects
FILE=*audio*effects*
rm -f `find $MODDIR/system -type f -name $FILE`
AEC=`find $ETC -maxdepth 1 -type f -name $FILE.conf`
VAEC=`find $VETC -maxdepth 1 -type f -name $FILE.conf`
AEX=`find $ETC -maxdepth 1 -type f -name $FILE.xml`
VAEX=`find $VETC -maxdepth 1 -type f -name $FILE.xml`
cp -f $AEC $MODETC
cp -f $VAEC $MODVETC
cp -f $AEX $MODETC
cp -f $VAEX $MODVETC

# audio policy
FILE="*policy*.conf
*policy*.xml"
rm -f `find $MODDIR/system -type f -name *policy*`
for FILES in $FILE; do
  AP=`find $VETC -maxdepth 1 -type f -name $FILES`
  AP2=`find $VETC/audio -maxdepth 1 -type f -name $FILES`
  cp -f $AP $MODVETC
  cp -f $AP2 $MODVETC/audio
done

# media codecs
FILE=media_codecs_vendor.xml
rm -f $MODVETC/$FILE
FOLDER=$AML/system/vendor/etc
if [ -d $FOLDER ]; then
  cp -f $VETC/$FILE $FOLDER
else
  cp -f $VETC/$FILE $MODVETC
fi

# run
sh $MODDIR/.aml.sh

# delete directory
DIR=/data/misc/dts
if [ -d $DIR ]; then
  rm -rf $DIR
fi

# delete directory
DIR=/data/misc/aw
if [ -d $DIR ]; then
  rm -rf $DIR
fi

# directory
DIR=/data/vendor/audio/dts
if [ ! -d $DIR ]; then
  mkdir -p $DIR
fi
chmod 0771 $DIR
chown 1013.1005 $DIR

# cleaning
FILE=$MODDIR/cleaner.sh
if [ -f $FILE ]; then
  sh $FILE
  rm -f $FILE
fi



