ui_print " "

# info
MODVER=`grep_prop version $MODPATH/module.prop`
MODVERCODE=`grep_prop versionCode $MODPATH/module.prop`
ui_print "id=$MODID"
ui_print "version=$MODVER"
ui_print "versionCode=$MODVERCODE"
ui_print "MagiskVersion=$MAGISK_VER"
ui_print "MagiskVersionCode=$MAGISK_VER_CODE"
ui_print " "

# sdk
NUM=26
if [ "$API" -lt $NUM ]; then
  ui_print "! Unsupported SDK $API. You have to upgrade your"
  ui_print "  Android version at least SDK API $NUM to use this"
  ui_print "  module."
  abort
else
  ui_print "- SDK $API"
  ui_print " "
fi

# store
clean_rules() {
  rm -f $MODPATH/sepolicy.rule
  rm -rf /metadata/magisk/$MODID
  rm -rf /mnt/vendor/persist/magisk/$MODID
  rm -rf /persist/magisk/$MODID
  rm -rf /data/unencrypted/magisk/$MODID
  rm -rf /cache/magisk/$MODID
}
permissive() {
  SELINUX=`getenforce`
  if [ "$SELINUX" == Enforcing ]; then
    setenforce 0
    SELINUX=`getenforce`
    if [ "$SELINUX" == Enforcing ]; then
      abort "! Your device can't be turned to Permissive state."
    fi
    setenforce 1
  fi
  sed -i '1i\
SELINUX=`getenforce`\
if [ "$SELINUX" == Enforcing ]; then\
  setenforce 0\
fi\' $MODPATH/post-fs-data.sh
}

# permissive
if getprop | grep -Eq "dts.permissive\]: \[1"; then
  ui_print "- Using permissive method"
  clean_rules
  permissive
  ui_print " "
elif getprop | grep -Eq "dts.permissive\]: \[2"; then
  ui_print "- Using both permissive and SE policy patch"
  permissive
  ui_print " "
fi

# bit
if [ "$IS64BIT" != true ]; then
  ui_print "- 32 bit"
  rm -rf `find $MODPATH/system -type d -name *64`
else
  ui_print "- 64 bit"
fi
ui_print " "

# framework.jar
ui_print "- Checking framework.jar support..."
ui_print "  Please wait..."
if ! grep -Eq DEVICE_OUT_ALL_A2DP_SET /system/framework/framework.jar || ! grep -Eq DEVICE_OUT_ALL_HDMI_SYSTEM_AUDIO_SET /system/framework/framework.jar; then
  ui_print "  Using another AudioWizard.apk"
  cp -rf $MODPATH/system10/* $MODPATH/system
fi
rm -rf $MODPATH/system10
ui_print " "

# cleaning
ui_print "- Cleaning..."
APP="AudioWizardView
     AudioWizard
     com.asus.maxxaudio.audiowizard
     com.asus.maxxaudio"
for APPS in $APP; do
  rm -f `find /data/dalvik-cache /data/system/package_cache -type f -name *$APPS*`
done
rm -f $MODPATH/LICENSE
conflict() {
  rm -rf /data/adb/modules_update/$MODULE
  rm -f /data/adb/modules/$MODULE/update
  touch /data/adb/modules/$MODULE/remove
  sh /data/adb/modules/$MODULE/uninstall.sh
  rm -f /data/adb/modules/$MODULE/uninstall.sh
  rm -rf /metadata/magisk/$MODULE
  rm -rf /mnt/vendor/persist/magisk/$MODULE
  rm -rf /persist/magisk/$MODULE
  rm -rf /data/unencrypted/magisk/$MODULE
  rm -rf /cache/magisk/$MODULE
}
MODULE=DTS_HPX
conflict
MODULE=DTSX_Ultra
conflict
MODULE=DTSXUltra
conflict
ui_print " "

# store
cleanup() {
  if [ ! -f $FOLDER/uninstall.sh ]; then
    FOLDER=/data/adb/modules_update/$MODID
  fi
  sh $FOLDER/uninstall.sh
}

# cleanup
FOLDER=/data/adb/modules/$MODID
FILE=$FOLDER/module.prop
if getprop | grep -Eq "dts.cleanup\]: \[1"; then
  ui_print "- Cleaning-up $MODID data..."
  cleanup
  ui_print " "
elif [ -d $FOLDER ] && ! grep -Eq "$MODNAME" $FILE; then
  ui_print "- Different version detected"
  ui_print "  Cleaning-up $MODID data..."
  cleanup
  ui_print " "
fi

# patch files
if getprop | grep -Eq "dts.patch\]: \[1"; then
  ui_print "- Patching files systemlessly..."
  ui_print "  Please wait..."
  FILE=`find $MODPATH/system/vendor/lib* -type f`
  sed -i 's/ro.build.product/ro.audio.product/g' $FILE
  sed -i 's/ro.build.product/ro.audio.product/g' $MODPATH/system.prop
  sed -i 's/ro.build.product/ro.audio.product/g' $MODPATH/service.sh
  ui_print " "
fi

# store
check_app() {
  FILE=`find /system /product -type f -name $APP.apk`
  if echo $FILE | grep -Eq apk; then
    ui_print "- Checking $APP app..."
    ui_print "  Please wait..."
    if grep -Eq $UUID $FILE; then
      ui_print "  Your $APP app will be hidden"
      mkdir $MODPATH/system/app/$APP
      touch $MODPATH/system/app/$APP/.replace
      chmod 0755 $MODPATH/system/app/$APP
      mkdir $MODPATH/system/priv-app/$APP
      touch $MODPATH/system/priv-app/$APP/.replace
      chmod 0755 $MODPATH/system/priv-app/$APP
      mkdir $MODPATH/system/product/app/$APP
      touch $MODPATH/system/product/app/$APP/.replace
      chmod 0755 $MODPATH/system/product/app/$APP
      mkdir $MODPATH/system/product/priv-app/$APP
      touch $MODPATH/system/product/priv-app/$APP/.replace
      chmod 0755 $MODPATH/system/product/priv-app/$APP
      mkdir $MODPATH/system/product/preinstall/$APP
      touch $MODPATH/system/product/preinstall/$APP/.replace
      chmod 0755 $MODPATH/system/product/preinstall/$APP
    fi
    ui_print " "
  fi
}

# misoundfx
UUID=5b8e36a5-144a-4c38-b1d7-0002a5d5c51b
APP=XiaomiParts
check_app
APP=ZenfoneParts
check_app
APP=ZenParts
check_app
APP=GalaxyParts
check_app

# stream mode
PROP=`getprop stream.mode`
FILE=$MODPATH/.aml.sh
if echo "$PROP" | grep -Eq r; then
  ui_print "- Activating ring stream..."
  sed -i 's/#r//g' $FILE
  ui_print " "
fi
if echo "$PROP" | grep -Eq a; then
  ui_print "- Activating alarm stream..."
  sed -i 's/#a//g' $FILE
  ui_print " "
fi
if echo "$PROP" | grep -Eq v; then
  ui_print "- Activating voice_call stream..."
  sed -i 's/#v//g' $FILE
  ui_print " "
fi
if echo "$PROP" | grep -Eq n; then
  ui_print "- Activating notification stream..."
  sed -i 's/#n//g' $FILE
  ui_print " "
fi

# permission
ui_print "- Setting permission..."
FOLDER=`find $MODPATH/system/vendor -type d`
for FOLDERS in $FOLDER; do
  chown 0.2000 $FOLDERS
done
chcon -R u:object_r:system_lib_file:s0 $MODPATH/system/lib*
chcon -R u:object_r:vendor_file:s0 $MODPATH/system/vendor
chcon -R u:object_r:vendor_configs_file:s0 $MODPATH/system/vendor/etc
ui_print " "

# store
copy_sepolicy_rules() {
  rm -rf /data/unencrypted/magisk/* /cache/magisk/* /metadata/magisk/* /persist/magisk/* /mnt/vendor/persist/magisk/*
  mkdir /data/unencrypted/magisk /cache/magisk /metadata/magisk /persist/magisk /mnt/vendor/persist/magisk

  local RULESDIR
  local active_dir=$(magisk --path)/.magisk/mirror/sepolicy.rules
  if [ -L $active_dir ]; then
    RULESDIR=$(readlink $active_dir)
  elif [ -d /data/unencrypted ] && ! grep ' /data ' /proc/mounts | grep -qE 'dm-|f2fs'; then
    RULESDIR=/data/unencrypted/magisk
  elif grep -q ' /cache ' /proc/mounts; then
    RULESDIR=/cache/magisk
  elif grep -q ' /metadata ' /proc/mounts; then
    RULESDIR=/metadata/magisk
  elif grep -q ' /persist ' /proc/mounts; then
    RULESDIR=/persist/magisk
  elif grep -q ' /mnt/vendor/persist ' /proc/mounts; then
    RULESDIR=/mnt/vendor/persist/magisk
  else
    return
  fi

  for r in /data/adb/modules*/*/sepolicy.rule; do
    [ -f "$r" ] || continue
    local MODDIR=${r%/*}
    [ -f $MODDIR/disable ] && continue
    [ -f $MODDIR/remove ] && continue
    local MODNAME=${MODDIR##*/}
    mkdir -p $RULESDIR/$MODNAME
    cp -f $r $RULESDIR/$MODNAME/sepolicy.rule
  done
}





