MODDIR=${0%/*}

# destinations
MODAEC=`find $MODDIR/system -type f -name *audio*effects*.conf`
MODAEX=`find $MODDIR/system -type f -name *audio*effects*.xml`
MODAP=`find $MODDIR/system/vendor/etc -type f -name *policy*`
MODAPX=`find $MODDIR/system/vendor/etc -type f -name *policy*.xml`
MODMC=$MODDIR/system/vendor/etc/media_codecs_vendor.xml
LIBPATH="\/vendor\/lib\/soundfx"

# store
NAME=dtsaudio
LIB=libdtsaudio.so
UUID=146edfc0-7ed2-11e4-80eb-0002a5d5c51b
RMV="$LIB
$NAME
libeagle.so
eagle_pipeline
eagle
$UUID
libmisoundfx.so
misoundfx
5b8e36a5-144a-4c38-b1d7-0002a5d5c51b
libsamsungSoundbooster_plus_legacy.so
libsamsungSoundbooster_plus.so
soundbooster_plus
50de45f0-5d4c-11e5-a837-0800200c9a66
libaudiosaplus_sec_legacy.so
libaudiosaplus_sec.so
soundalive_sec
soundalive
cf65eb39-ce2f-48a8-a903-ceb818c06745
05227ea0-50bb-11e3-ac69-0002a5d5c51b
0b2dbc60-50bb-11e3-988b-0002a5d5c51b
libmysound_legacy.so
libmysound.so
mysound
dha
263a88e0-50b1-11e2-bcfd-0800200c9a66
37155c20-50bb-11e3-9fac-0002a5d5c51b
3ef69260-50bb-11e3-931e-0002a5d5c51b
libsamsungSoundbooster_tdm_legacy.so
tdm
beb1d058-916a-4adf-9cfe-54ee5ba8c4a5
libvolumemonitor_energy.so
volumemonitor
16311c29-bb53-4415-b7af-ae653e812de8
libmyspace.so
myspace
sa3d
3462a6e0-655a-11e4-8b67-0002a5d5c51b
1c91fca0-664a-11e4-b8c2-0002a5d5c51b
c7a84e61-eebe-4fcc-bc53-efcb841b4625
libLifevibes_lvverx.so
lmfv
fens
3b75f00-93ce-11e0-9fb8-0002a5d5c51b
d6dbf400-93ce-11e0-bcd7-0002a5d5c51b
df0afc20-93ce-11e0-98de-0002a5d5c51b
989d9460-413d-11e1-8b0d-0002a5d5c51b
cbcc5980-476d-11e1-82ee-0002a5d5c51b
libgearvr.so
vr360audio
vr3d
e6388202-e7a4-4c72-b68a-332eeeba269b"

# patch audio effects conf
if echo $MODAEC | grep -Eq conf; then
  for RMVS in $RMV; do
    sed -i "s/$RMVS/removed/g" $MODAEC
  done
  sed -i "s/    path \/vendor\/lib\/soundfx\/removed//g" $MODAEC
  sed -i "s/    path \/system\/lib\/soundfx\/removed//g" $MODAEC
  sed -i "s/    path \/vendor\/lib\/removed//g" $MODAEC
  sed -i "s/    path \/system\/lib\/removed//g" $MODAEC
  sed -i "/^libraries {/a\  $NAME {\n    path $LIBPATH\/$LIB\n  }" $MODAEC
  sed -i "/^effects {/a\  $NAME {\n    library $NAME\n    uuid $UUID\n  }" $MODAEC
  sed -i "/^        ring_helper {/ {;N s/        ring_helper {\n        }//}" $MODAEC
  sed -i "/^        alarm_helper {/ {;N s/        alarm_helper {\n        }//}" $MODAEC
  sed -i "/^        music_helper {/ {;N s/        music_helper {\n        }//}" $MODAEC
  sed -i "/^        voice_helper {/ {;N s/        voice_helper {\n        }//}" $MODAEC
  sed -i "/^        notification_helper {/ {;N s/        notification_helper {\n        }//}" $MODAEC
  sed -i "/^        music_post_proc {/ {;N s/        music_post_proc {\n        }//}" $MODAEC
  sed -i "/^        voice_post_proc {/ {;N s/        voice_post_proc {\n        }//}" $MODAEC
  sed -i "/^        notification_post_proc {/ {;N s/        notification_post_proc {\n        }//}" $MODAEC
  sed -i "/^        removed {/ {;N s/        removed {\n        }//}" $MODAEC
  sed -i "/^        aec {/ {;N s/        aec {\n        }//}" $MODAEC
  sed -i "/^        agc {/ {;N s/        agc {\n        }//}" $MODAEC
  sed -i "/^        ns {/ {;N s/        ns {\n        }//}" $MODAEC
  sed -i "/^    aec {/ {;N s/    aec {\n    }//}" $MODAEC
  sed -i "/^    agc {/ {;N s/    agc {\n    }//}" $MODAEC
  sed -i "/^    ns {/ {;N s/    ns {\n    }//}" $MODAEC
  sed -i "/^    ns  {/ {;N s/    ns  {\n    }//}" $MODAEC
  if ! grep -Eq '^output_session_processing {' $MODAEC; then
    sed -i -e '$a\
output_session_processing {\
    music {\
    }\
    ring {\
    }\
    alarm {\
    }\
    voice_call {\
    }\
    notification {\
    }\
}\' $MODAEC
  else
    if ! grep -Eq '^    notification {' $MODAEC; then
      sed -i "/^output_session_processing {/a\    notification {\n    }" $MODAEC
    fi
    if ! grep -Eq '^    voice_call {' $MODAEC; then
      sed -i "/^output_session_processing {/a\    voice_call {\n    }" $MODAEC
    fi
    if ! grep -Eq '^    alarm {' $MODAEC; then
      sed -i "/^output_session_processing {/a\    alarm {\n    }" $MODAEC
    fi
    if ! grep -Eq '^    ring {' $MODAEC; then
      sed -i "/^output_session_processing {/a\    ring {\n    }" $MODAEC
    fi
    if ! grep -Eq '^    music {' $MODAEC; then
      sed -i "/^output_session_processing {/a\    music {\n    }" $MODAEC
    fi
  fi
  sed -i "/^    music {/a\        $NAME {\n        }" $MODAEC
#r  sed -i "/^    ring {/a\        $NAME {\n        }" $MODAEC
#a  sed -i "/^    alarm {/a\        $NAME {\n        }" $MODAEC
#v  sed -i "/^    voice_call {/a\        $NAME {\n        }" $MODAEC
#n  sed -i "/^    notification {/a\        $NAME {\n        }" $MODAEC
fi

# patch audio effects xml
if echo $MODAEX | grep -Eq xml; then
  for RMVS in $RMV; do
    sed -i "s/\"$RMVS\"/\"removed\"/g" $MODAEX
  done
  sed -i 's/<library name="removed" path="removed"\/>//g' $MODAEX
  sed -i 's/<effect name="removed" library="removed" uuid="removed"\/>//g' $MODAEX
  sed -i "/<libraries>/a\        <library name=\"$NAME\" path=\"$LIB\"\/>" $MODAEX
  sed -i "/<effects>/a\        <effect name=\"$NAME\" library=\"$NAME\" uuid=\"$UUID\"\/>" $MODAEX
  sed -i 's/<apply effect="ring_helper"\/>//g' $MODAEX
  sed -i 's/<apply effect="alarm_helper"\/>//g' $MODAEX
  sed -i 's/<apply effect="music_helper"\/>//g' $MODAEX
  sed -i 's/<apply effect="voice_helper"\/>//g' $MODAEX
  sed -i 's/<apply effect="notification_helper"\/>//g' $MODAEX
  sed -i 's/<apply effect="music_post_proc"\/>//g' $MODAEX
  sed -i 's/<apply effect="voice_post_proc"\/>//g' $MODAEX
  sed -i 's/<apply effect="notification_post_proc"\/>//g' $MODAEX
  sed -i 's/<apply effect="removed"\/>//g' $MODAEX
  sed -i 's/<apply effect="aec"\/>//g' $MODAEX
  sed -i 's/<apply effect="agc"\/>//g' $MODAEX
  sed -i 's/<apply effect="ns"\/>//g' $MODAEX
  if ! grep -Eq '<postprocess>' $MODAEX || grep -Eq '<!-- Audio post processor' $MODAEX; then
    sed -i '/<\/effects>/a\
    <postprocess>\
        <stream type="music">\
        <\/stream>\
        <stream type="ring">\
        <\/stream>\
        <stream type="alarm">\
        <\/stream>\
        <stream type="voice_call">\
        <\/stream>\
        <stream type="notification">\
        <\/stream>\
    <\/postprocess>' $MODAEX
  else
    if ! grep -Eq '<stream type="notification">' $MODAEX || grep -Eq '<!-- YunMang.Xiao@PSW.MM.Dolby' $MODAEX; then
      sed -i "/<postprocess>/a\        <stream type=\"notification\">\n        <\/stream>" $MODAEX
    fi
    if ! grep -Eq '<stream type="voice_call">' $MODAEX; then
      sed -i "/<postprocess>/a\        <stream type=\"voice_call\">\n        <\/stream>" $MODAEX
    fi
    if ! grep -Eq '<stream type="alarm">' $MODAEX || grep -Eq '<!-- YunMang.Xiao@PSW.MM.Dolby' $MODAEX; then
      sed -i "/<postprocess>/a\        <stream type=\"alarm\">\n        <\/stream>" $MODAEX
    fi
    if ! grep -Eq '<stream type="ring">' $MODAEX || grep -Eq '<!-- YunMang.Xiao@PSW.MM.Dolby' $MODAEX; then
      sed -i "/<postprocess>/a\        <stream type=\"ring\">\n        <\/stream>" $MODAEX
    fi
    if ! grep -Eq '<stream type="music">' $MODAEX || grep -Eq '<!-- YunMang.Xiao@PSW.MM.Dolby' $MODAEX; then
      sed -i "/<postprocess>/a\        <stream type=\"music\">\n        <\/stream>" $MODAEX
    fi
  fi
  sed -i "/<stream type=\"music\">/a\            <apply effect=\"$NAME\"\/>" $MODAEX
#r  sed -i "/<stream type=\"ring\">/a\            <apply effect=\"$NAME\"\/>" $MODAEX
#a  sed -i "/<stream type=\"alarm\">/a\            <apply effect=\"$NAME\"\/>" $MODAEX
#v  sed -i "/<stream type=\"voice_call\">/a\            <apply effect=\"$NAME\"\/>" $MODAEX
#n  sed -i "/<stream type=\"notification\">/a\            <apply effect=\"$NAME\"\/>" $MODAEX
fi

# patch audio policy
if echo $MODAP | grep -Eq conf || echo $MODAP | grep -Eq xml; then
  sed -i 's/RAW/NONE/g' $MODAP
  sed -i 's/,raw//g' $MODAP
  sed -i 's/COMPRESS_OFFLOAD/NONE/g' $MODAP
  sed -i 's/,compressed_offload//g' $MODAP
fi

# patch audio policy xml
if echo $MODAPX | grep -Eq xml; then
  if ! grep -Eq 'format="AUDIO_FORMAT_DTS"' $MODAPX; then
    sed -i '/AUDIO_FORMAT_MP3/i\
                    <profile name="" format="AUDIO_FORMAT_DTS"\
                             samplingRates="32000,44100,48000"\
                             channelMasks="AUDIO_CHANNEL_OUT_MONO,AUDIO_CHANNEL_OUT_STEREO,AUDIO_CHANNEL_OUT_2POINT1,AUDIO_CHANNEL_OUT_QUAD,AUDIO_CHANNEL_OUT_PENTA,AUDIO_CHANNEL_OUT_5POINT1"/>' $MODAPX
  fi
  if ! grep -Eq 'format="AUDIO_FORMAT_DTS_HD"' $MODAPX; then
      sed -i '/AUDIO_FORMAT_MP3/i\
                    <profile name="" format="AUDIO_FORMAT_DTS_HD"\
                             samplingRates="32000,44100,48000,64000,88200,96000,128000,176400,192000"\
                             channelMasks="AUDIO_CHANNEL_OUT_MONO,AUDIO_CHANNEL_OUT_STEREO,AUDIO_CHANNEL_OUT_2POINT1,AUDIO_CHANNEL_OUT_QUAD,AUDIO_CHANNEL_OUT_PENTA,AUDIO_CHANNEL_OUT_5POINT1,AUDIO_CHANNEL_OUT_6POINT1,AUDIO_CHANNEL_OUT_7POINT1"/>' $MODAPX
  fi
fi

# patch media codecs
if [ -f $MODMC ]; then
  sed -i '/<MediaCodecs>/a\
    <Include href="media_codecs_dts.xml"/>' $MODMC
fi




