#/system/bin/sh

test "$1" = "" && exit 0

action=$1
setprop Key.Esa.sate $1


function schedutil_set_key (){
up_rate_limit_us="/sys/devices/system/cpu/cpu4/cpufreq/schedutil/up_rate_limit_us"
down_rate_limit_us="/sys/devices/system/cpu/cpu4/cpufreq/schedutil/down_rate_limit_us"
hispeed_load="/sys/devices/system/cpu/cpu4/cpufreq/schedutil/hispeed_load"
pl="/sys/devices/system/cpu/cpu4/cpufreq/schedutil/pl"
hispeed_freq="/sys/devices/system/cpu/cpu4/cpufreq/schedutil/hispeed_freq"

up_rate_limit_us_lite="/sys/devices/system/cpu/cpu0/cpufreq/schedutil/up_rate_limit_us"
down_rate_limit_us_lite="/sys/devices/system/cpu/cpu0/cpufreq/schedutil/down_rate_limit_us"
hispeed_load_lite="/sys/devices/system/cpu/cpu0/cpufreq/schedutil/hispeed_load"
pl_lite="/sys/devices/system/cpu/cpu0/cpufreq/schedutil/pl"
hispeed_freq_lite="/sys/devices/system/cpu/cpu0/cpufreq/schedutil/hispeed_freq"

test -e $down_rate_limit_us_lite && echo '0' >$down_rate_limit_us_lite
test -e $up_rate_limit_us_lite && echo '0' >$up_rate_limit_us_lite
test -e $up_rate_limit_us && echo '0' >$down_rate_limit_us
test -e $up_rate_limit_us && echo '0' >$up_rate_limit_us
test -e $pl_lite && echo '1' >$pl_lite
test -e $pl && echo '1' >$pl

if test  "$(getprop Key.Esa.sate)" = "performance" -o "$(getprop Key.Esa.sate)" = "fast" ;then
test -e $hispeed_freq_lite && echo '1516800' >$hispeed_freq_lite
test -e $hispeed_freq && echo '1689600' >$hispeed_freq
test -e $hispeed_load_lite && echo '85' >$hispeed_load_lite
test -e $hispeed_load && echo '90' >$hispeed_load
else
test -e $hispeed_freq_lite && echo '0' >$hispeed_freq_lite
test -e $hispeed_freq && echo '0' >$hispeed_freq
test -e $hispeed_load_lite && echo '100' >$hispeed_load_lite
test -e $hispeed_load && echo '100' >$hispeed_load
fi
}


function GPU_POWER_SET () {
local GPUtable=`cat /sys/class/kgsl/kgsl-3d0/devfreq/available_frequencies | sed 's/[[:space:]]/\n/g' `
local GPUtablelevel=`cat /sys/class/kgsl/kgsl-3d0/devfreq/available_frequencies | sed 's/[[:space:]]/\n/g' | wc -l `
local GPUMIN=$( echo "$GPUtable" | sed -n "1p" )
local GPUMAX=$( echo "$GPUtable" | sed -n ""$(($GPUtablelevel))"p" )
local gpumax="/sys/class/kgsl/kgsl-3d0/max_gpuclk"
local gpumin="/sys/class/kgsl/kgsl-3d0/devfreq/min_freq"
local gpuminpower="/sys/class/kgsl/kgsl-3d0/min_pwrlevel"
local gpumaxpower="/sys/class/kgsl/kgsl-3d0/max_pwrlevel"
local gpudefaultpower="/sys/class/kgsl/kgsl-3d0/default_pwrlevel"
echo "$GPUMIN" > $gpumin
echo "$GPUMAX" > $gpumax
echo "$GPUtablelevel" > $gpuminpower
echo "$GPUtablelevel" > $gpudefaultpower

if test "$GPUtablelevel" -ge "9" -a "$(getprop Key.Esa.sate)" = "powersave" ;then
echo "5" > $gpumaxpower
elif test "$GPUtablelevel" -le "7" -a "$(getprop Key.Esa.sate)" = "powersave" ;then
echo "3" > $gpumaxpower
fi

if test "$GPUtablelevel" -ge "9" -a "$(getprop Key.Esa.sate)" = "balance" ;then
echo "2" > $gpumaxpower
elif test "$GPUtablelevel" -le "7" -a "$(getprop Key.Esa.sate)" = "balance" ;then
echo "1" > $gpumaxpower
fi

if test "$(getprop Key.Esa.sate)" = "performance" -o "$(getprop Key.Esa.sate)" = "fast" ;then
echo "0" > $gpumaxpower
fi

}


function set_value() {
	if test -f "$2" ;then
		chmod 0777 "$2" > /dev/null 2>&1
		echo "$1" > "$2" 2>/dev/null
		chmod 0755 "$2" > /dev/null 2>&1
	fi
}

function set_governor_cpu (){
governor0=`cat /sys/devices/system/cpu/cpu0/cpufreq/scaling_governor`
governor4=`cat /sys/devices/system/cpu/cpu4/cpufreq/scaling_governor`

if test  "$governor0" != "schedutil" ; then
  echo 'schedutil' > /sys/devices/system/cpu/cpu0/cpufreq/scaling_governor
fi
if test  "$governor4" != "schedutil" ; then
  echo 'schedutil' > /sys/devices/system/cpu/cpu4/cpufreq/scaling_governor
fi
}

set_governor_cpu 2>/dev/null
GPU_POWER_SET 2>/dev/null 
schedutil_set_key 2>/dev/null


function check_mode () {
	local file=/data/adb/modules/845-ESA-key/module.prop
	local systemprop=/data/adb/modules/845-ESA-key/system.prop
	sed -i '/description/d;/^[[:space:]]*$/d' $file
	echo "description=当前模式为：["$(getprop Key.Esa.sate)"]，适用于MIUI 官方内核的845调度。用shell指令输入 [ sh /data/powercfg.sh balance ]，指令可进行切换调度，或者使用[ setprop Key.Esa.sate balance ] (balance是模式)。" >> $file
	sed -i "s/Key.Esa.sate.*/Key.Esa.sate="$(getprop Key.Esa.sate)"/g" $systemprop
}


function set_input_boost_freq() {
	local c0="$1"
	local c1="$2"
	local ms="$3"
	echo "0:$c0 1:$c0 2:$c0 3:$c0 4:$c1 5:$c1 6:$c1 7:$c1" > /sys/module/cpu_boost/parameters/input_boost_freq
	echo $ms > /sys/module/cpu_boost/parameters/input_boost_ms
}

function set_cpu_freq() {
	echo "0:$2 1:$2 2:$2 3:$2 4:$4 5:$4 6:$4 7:$4" > /sys/module/msm_performance/parameters/cpu_max_freq
	echo $1 > /sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq
	echo $2 > /sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq
	echo $3 > /sys/devices/system/cpu/cpu4/cpufreq/scaling_min_freq
	echo $4 > /sys/devices/system/cpu/cpu4/cpufreq/scaling_max_freq
}


if test "$action" = "powersave" -o "$(getprop Key.Esa.sate)" = "powersave" ;then
	set_cpu_freq 300000 1516800 825600 1996800
	set_input_boost_freq 1766400 2400000 40

	set_value '0' /proc/sys/kernel/sched_boost
	set_value '0-3' /dev/cpuset/foreground/cpus
	set_value "256" /sys/block/sda/queue/read_ahead_kb
	set_value "256" /sys/block/sde/queue/read_ahead_kb
	check_mode

elif test "$action" = "balance" -o "$(getprop Key.Esa.sate)" = "balance" ;then
	set_cpu_freq 300000 1689600 300000 2246400
	set_input_boost_freq 1766400 2649600 120

	set_value '0' /proc/sys/kernel/sched_boost
	set_value '0-5' /dev/cpuset/foreground/cpus
	set_value "256" /sys/block/sda/queue/read_ahead_kb
	set_value "256" /sys/block/sde/queue/read_ahead_kb
	check_mode

elif test  "$action" = "performance" -o "$(getprop Key.Esa.sate)" = "performance" ;then
	set_cpu_freq 576000 1766400 1209600 2803200
	set_input_boost_freq 1766400 2803200 80

	set_value '0' /proc/sys/kernel/sched_boost
	set_value '0-7' /dev/cpuset/foreground/cpus
	set_value "128" /sys/block/sda/queue/read_ahead_kb
	set_value "128" /sys/block/sde/queue/read_ahead_kb
	check_mode

elif test "$action" = "fast" -o "$(getprop Key.Esa.sate)" = "fast" ;then
	set_cpu_freq 300000 1766400 1996800 2803200
	set_input_boost_freq 1766400 2803200 150

	set_value '1' /proc/sys/kernel/sched_boost
	set_value '0-7' /dev/cpuset/foreground/cpus
	set_value "128" /sys/block/sda/queue/read_ahead_kb
	set_value "128" /sys/block/sde/queue/read_ahead_kb
	check_mode

fi




