#!/system/bin/sh
export PATH=/system/bin:$(magisk --path)/.magisk/busybox:$PATH

package=`pm list package -a | grep -w com.miui.analytics | wc -l `

test "$package" -gt "0" && {
	pm uninstall --user 0 com.miui.analytics > /dev/null 2>&1 && echo "－ 卸载成功！" || {
	notinstallpackage=$(pm uninstall --user 0 com.miui.analytics)
	test "$notinstallpackage" = "Failure [not installed for 0]" && echo "－ 已经从用户0卸载！"
	} || echo "- 卸载失败！"
} || echo "－ 未安装Analysis ！"



function X_Analysis(){
	if test -e "$1" ;then
		rm -rf "$1"
		touch "$1"
		chmod 000 "$1"
		chattr +i "$1"
	fi
}

function RE_Analysis(){
	if test -e "$1" ;then
		chattr -i "$1"
		chmod 777 "$1"
		rm -rf "$1"
	fi
}

echo "－ 查找 Analysis 文件夹中……"
echo "－ 请耐心等待……"
dir=`find /data/data /data/user /data/user_de /data/media/*[0-9]*/Android -iname '*app_analytics*' -type d 2> /dev/null `

test "$dir" != "" && {
	echo "－ 找到Analysis 文件夹！"
	for file in $dir ;do
		echo "－ $file "
		X_Analysis $file && echo "－ 删除成功！" || echo "－ 删除失败！"
	done
} || echo "－ 未找到Analysis 文件夹！"


