#!/system/bin/sh


function GPU_POWER_SET () {
local GPUtable=`cat /sys/class/kgsl/kgsl-3d0/devfreq/available_frequencies | sed 's/[[:space:]]/\n/g' `
local GPUtablelevel=`cat /sys/class/kgsl/kgsl-3d0/devfreq/available_frequencies | sed 's/[[:space:]]/\n/g' | wc -l `
local GPUMIN=$( echo "$GPUtable" | sed -n "1p" )
local GPUMAX=$( echo "$GPUtable" | sed -n ""$(($GPUtablelevel))"p" )
local gpumax="/sys/class/kgsl/kgsl-3d0/max_gpuclk"
local gpumin="/sys/class/kgsl/kgsl-3d0/devfreq/min_freq"
local gpuminpower="/sys/class/kgsl/kgsl-3d0/min_pwrlevel"
local gpumaxpower="/sys/class/kgsl/kgsl-3d0/max_pwrlevel"
local gpudefaultpower="/sys/class/kgsl/kgsl-3d0/default_pwrlevel"
echo "$GPUMIN" > $gpumin
echo "$GPUMAX" > $gpumax
echo "$GPUtablelevel" > $gpuminpower
echo "$GPUtablelevel" > $gpudefaultpower
}


function schedutil_set_key (){
up_rate_limit_us="/sys/devices/system/cpu/cpu4/cpufreq/schedutil/up_rate_limit_us"
down_rate_limit_us="/sys/devices/system/cpu/cpu4/cpufreq/schedutil/down_rate_limit_us"
hispeed_load="/sys/devices/system/cpu/cpu4/cpufreq/schedutil/hispeed_load"
pl="/sys/devices/system/cpu/cpu4/cpufreq/schedutil/pl"
hispeed_freq="/sys/devices/system/cpu/cpu4/cpufreq/schedutil/hispeed_freq"

up_rate_limit_us_lite="/sys/devices/system/cpu/cpu0/cpufreq/schedutil/up_rate_limit_us"
down_rate_limit_us_lite="/sys/devices/system/cpu/cpu0/cpufreq/schedutil/down_rate_limit_us"
hispeed_load_lite="/sys/devices/system/cpu/cpu0/cpufreq/schedutil/hispeed_load"
pl_lite="/sys/devices/system/cpu/cpu0/cpufreq/schedutil/pl"
hispeed_freq_lite="/sys/devices/system/cpu/cpu0/cpufreq/schedutil/hispeed_freq"

test -e $down_rate_limit_us_lite && echo '0' >$down_rate_limit_us_lite
test -e $up_rate_limit_us_lite && echo '0' >$up_rate_limit_us_lite
test -e $up_rate_limit_us && echo '0' >$down_rate_limit_us
test -e $up_rate_limit_us && echo '0' >$up_rate_limit_us
test -e $pl_lite && echo '1' >$pl_lite
test -e $pl && echo '1' >$pl

if test  "$(getprop Key.Esa.sate)" = "performance" -o "$(getprop Key.Esa.sate)" = "fast" ;then
test -e $hispeed_freq_lite && echo '1516800' >$hispeed_freq_lite
test -e $hispeed_freq && echo '1689600' >$hispeed_freq
test -e $hispeed_load_lite && echo '85' >$hispeed_load_lite
test -e $hispeed_load && echo '90' >$hispeed_load
else
test -e $hispeed_freq_lite && echo '0' >$hispeed_freq_lite
test -e $hispeed_freq && echo '0' >$hispeed_freq
test -e $hispeed_load_lite && echo '100' >$hispeed_load_lite
test -e $hispeed_load && echo '100' >$hispeed_load
fi
}

set_value() {
	if test -f "$2" ;then
		chmod 0777 "$2" >/dev/null 2>&1
		echo "$1" > "$2" && {
			chmod 0755 "$2" >/dev/null 2>&1
		} || echo "修改"$2"失败！"
	fi
}

stop perfd

#设置小核
#频率
#300000 403200 480000 576000 652800 748800 825600 902400 979200 1056000 1132800 1228800 1324800 1420800 1516800 1612800 1689600 1766400 
set_value "1689600" /sys/devices/system/cpu/cpufreq/policy0/scaling_max_freq
set_value "300000" /sys/devices/system/cpu/cpufreq/policy0/scaling_min_freq
set_value "schedutil" /sys/devices/system/cpu/cpufreq/policy0/scaling_governor

#设置大核
#频率
#825600 902400 979200 1056000 1209600 1286400 1363200 1459200 1536000 1612800 1689600 1766400 1843200 1920000 1996800 2092800 2169600 2246400 2323200 2400000 2476800 2553600 2649600 2803200
set_value "2246400" /sys/devices/system/cpu/cpufreq/policy4/scaling_max_freq
set_value "825600" /sys/devices/system/cpu/cpufreq/policy4/scaling_min_freq
set_value "schedutil" /sys/devices/system/cpu/cpufreq/policy4/scaling_governor

# Input boosting for Morons
set_value "0:1766400 4:2803200" /sys/module/cpu_boost/parameters/input_boost_freq

# CPUsets tuning
set_value "0-7" /dev/cpuset/top-app/cpus
set_value "0-1,6-7" /dev/cpuset/foreground/boost/cpus
set_value "0-7" /dev/cpuset/foreground/cpus
set_value "0-3" /dev/cpuset/background/cpus
set_value "0-3" /dev/cpuset/system-background/cpus
set_value "0-3,4-5" /dev/cpuset/restricted/cpus

#I/O调度
set_value "256" /sys/block/sda/queue/read_ahead_kb
set_value "256" /sys/block/sde/queue/read_ahead_kb

#vm
set_value "10" /proc/sys/vm/stat_interval
set_value "0" /proc/sys/vm/page-cluster
set_value "0" /sys/module/binder/parameters/debug_mask

#kernel
set_value "N" /sys/kernel/debug/debug_enabled
#for i in $(find /sys/block/*/queue/nr_requests);do set_value "36" "$i" ;done
set_value "off" /proc/sys/kernel/printk_devkmsg
set_value "0" /proc/sys/kernel/sched_schedstats

GPU_POWER_SET
schedutil_set_key
