osp_detect() {
  case $1 in
    *.conf) SPACES=$(sed -n "/^output_session_processing {/,/^}/ {/^ *music {/p}" $1 | sed -r "s/( *).*/\1/")
            EFFECTS=$(sed -n "/^output_session_processing {/,/^}/ {/^$SPACES\music {/,/^$SPACES}/p}" $1 | grep -E "^$SPACES +[A-Za-z]+" | sed -r "s/( *.*) .*/\1/g")
            for EFFECT in ${EFFECTS}; do
              SPACES=$(sed -n "/^effects {/,/^}/ {/^ *$EFFECT {/p}" $1 | sed -r "s/( *).*/\1/")
              [ "$EFFECT" != "atmos" ] && sed -i "/^effects {/,/^}/ {/^$SPACES$EFFECT {/,/^$SPACES}/ s/^/#/g}" $1
            done;;
     *.xml) EFFECTS=$(sed -n "/^ *<postprocess>$/,/^ *<\/postprocess>$/ {/^ *<stream type=\"music\">$/,/^ *<\/stream>$/ {/<stream type=\"music\">/d; /<\/stream>/d; s/<apply effect=\"//g; s/\"\/>//g; p}}" $1)
            for EFFECT in ${EFFECTS}; do
              [ "$EFFECT" != "atmos" ] && sed -ri "s/^( *)<apply effect=\"$EFFECT\"\/>/\1<\!--<apply effect=\"$EFFECT\"\/>-->/" $1
            done;;
  esac
}

# Tell user aml is needed if applicable
FILES=$(find $NVBASE/modules/*/system $MODULEROOT/*/system -type f -name "*audio_effects*.conf" -o -name "*audio_effects*.xml" 2>/dev/null)
if [ ! -z "$FILES" ] && [ ! "$(echo $FILES | grep '/aml/')" ]; then
  ui_print " "
  ui_print "   ! Conflicting audio mod found!"
  ui_print "   ! You will need to install !"
  ui_print "   ! Audio Modification Library !"
  sleep 3
fi

# Lib fix for pixel 2's, 3's, and essential phone
if $LIBWA; then
  ui_print "   Applying lib workaround..."
  if [ -f $ORIGDIR/system/lib/libstdc++.so ] && [ ! -f $ORIGDIR/vendor/lib/libstdc++.so ]; then
    cp_ch $ORIGDIR/system/lib/libstdc++.so $MODPATH/system/vendor/lib/libstdc++.so
  elif [ -f $ORIGDIR/vendor/lib/libstdc++.so ] && [ ! -f $ORIGDIR/system/lib/libstdc++.so ]; then
    cp_ch $ORIGDIR/vendor/lib/libstdc++.so $MODPATH/system/lib/libstdc++.so
  fi
fi

# Detect driver compatibility
ui_print " "
DRV=NEON
case $ABILONG in
  arm64*) JNI=arm64;;
  arm*) JNI=arm;;
  x86_64*) JNI=x86_64; DRV=x86;;
  x86*) JNI=x86; DRV=x86;;
  *64*) JNI=arm64;;
  *) JNI=arm;;
esac

mkdir -p $MODPATH/system/lib/soundfx
cp -f $MODPATH/custom/libv4a_fx_$DRV.so $MODPATH/system/lib/soundfx/libv4a_fx.so
sed -ri "s/version=(.*)/version=\1 (2.7.0.0)/" $MODPATH/module.prop
sed -i "s/<SOURCE>/$SOURCE/g" $MODPATH/common/sepolicy.sh

cp_ch $MODPATH/custom/ViPER4AndroidFX.apk $MODPATH/system/priv-app/ViPER4AndroidFX/ViPER4AndroidFX.apk
# App installation for oreo+
if [ $API -ge 26 ]; then
    install_script -l $MODPATH/common/viper.sh
    cp -f $MODPATH/system/priv-app/ViPER4AndroidFX/ViPER4AndroidFX.apk $MODPATH/ViPER4AndroidFX.apk
    rm -rf $MODPATH/system/priv-app/ViPER4AndroidFX
  else
    cp -f $MODPATH/custom/ViPER4AndroidFX.apk $SDCARD/ViPER4AndroidFX.apk
    ui_print " "
    ui_print "   ViPER4AndroidFX.apk copied to root of internal storage (sdcard)"
    ui_print "   Install manually after booting"
    sleep 2
fi

  ui_print " "
  ui_print "   Patching existing audio_effects files..."
CFGS="$(find /system /vendor -type f -name "*audio_effects*.conf" -o -name "*audio_effects*.xml")"
for OFILE in ${CFGS}; do
  FILE="$MODPATH$(echo $OFILE | sed "s|^/vendor|/system/vendor|g")"
  cp_ch -n $ORIGDIR$OFILE $FILE
  osp_detect $FILE
    case $FILE in
      *.conf) sed -i "/v4a_standard_fx {/,/}/d" $FILE
              sed -i "/v4a_fx {/,/}/d" $FILE
              sed -i "s/^effects {/effects {\n  v4a_standard_fx { #$MODID\n    library v4a_fx\n    uuid 41d3c987-e6cf-11e3-a88a-11aba5d5c51b\n  } #$MODID/g" $FILE
              sed -i "s/^libraries {/libraries {\n  v4a_fx { #$MODID\n    path $LIBPATCH\/lib\/soundfx\/libv4a_fx.so\n  } #$MODID/g" $FILE;;
      *.xml) sed -i "/v4a_standard_fx/d" $FILE
             sed -i "/v4a_fx/d" $FILE
             sed -i "/<libraries>/ a\        <library name=\"v4a_fx\" path=\"libv4a_fx.so\"\/><!--$MODID-->" $FILE
             sed -i "/<effects>/ a\        <effect name=\"v4a_standard_fx\" library=\"v4a_fx\" uuid=\"41d3c987-e6cf-11e3-a88a-11aba5d5c51b\"\/><!--$MODID-->" $FILE;;
    esac
  done
