#!/system/bin/sh
MODPATH=${0%/*}
SEINJECT=magiskpolicy
MAGISK=true
ROOT=""
SYS=/system
VEN=/system/vendor
LIBDIR=/system
MODID=dsplus
if [ -d /system/priv-app ]; then SOURCE=priv_app; else SOURCE=system_app; fi

if [ "$SEINJECT" != "/sbin/sepolicy-inject" ]; then
  $SEINJECT --live "allow $SOURCE property_socket sock_file { getattr open read write execute }" "allow $SOURCE init unix_stream_socket connectto" "permissive $SOURCE audio_prop"
else
  $SEINJECT -s $SOURCE -t init -c unix_stream_socket -p connectto -l
  $SEINJECT -s $SOURCE -t property_socket -c sock_file -p getattr,open,read,write,execute -l
  $SEINJECT -Z $SOURCE -l
  $SEINJECT -Z audio_prop -l
fi



# This script will be executed in late_start service mode
# More info in the main Magisk thread# selinux enforcing processing on most of devices
magiskpolicy --live "allow audioserver audioserver_tmpfs file { read write execute }"  "allow audioserver system_file file { execmod }"  "allow mediaserver mediaserver_tmpfs file { read write execute }"  "allow mediaserver system_file file { execmod }"  "allow audioserver unlabeled file { read write execute open getattr }"  "allow hal_audio_default hal_audio_default process { execmem }"  "allow hal_audio_default hal_audio_default_tmpfs file { execute }"  "allow hal_audio_default audio_data_file dir { search }" 
