MODDIR=${0%/*}

# destinations
LIBPATH="\/vendor\/lib\/soundfx"
MODAEC=`find $MODDIR/system -type f -name *audio*effects*.conf`
MODAEX=`find $MODDIR/system -type f -name *audio*effects*.xml`
MODAP=`find $MODDIR/system -type f -name *policy*.conf -o -name *policy*.xml`

# function
remove_conf() {
  for RMVS in $RMV; do
    sed -i "s/$RMVS/removed/g" $MODAEC
  done
  sed -i 's/    path \/vendor\/lib\/soundfx\/removed//g' $MODAEC
  sed -i 's/    path \/system\/lib\/soundfx\/removed//g' $MODAEC
  sed -i 's/    path \/vendor\/lib\/removed//g' $MODAEC
  sed -i 's/    path \/system\/lib\/removed//g' $MODAEC
  sed -i "/^        removed {/ {;N s/        removed {\n        }//}" $MODAEC
}
remove_xml() {
  for RMVS in $RMV; do
    sed -i "s/\"$RMVS\"/\"removed\"/g" $MODAEX
  done
  sed -i 's/<library name="removed" path="removed"\/>//g' $MODAEX
  sed -i 's/<effect name="removed" library="removed" uuid="removed"\/>//g' $MODAEX
  sed -i 's/<apply effect="removed"\/>//g' $MODAEX
}

# store
LIB=libmaxxeffect-cembedded.so
NAME=maxxaudio3
UUID=ae12da60-99ac-11df-b456-0002a5d5c51b
RMV="$LIB
$NAME
$UUID
libsamsungSoundbooster_plus_legacy.so
libsamsungSoundbooster_plus.so
soundbooster_plus
50de45f0-5d4c-11e5-a837-0800200c9a66
libaudiosaplus_sec_legacy.so
libaudiosaplus_sec.so
soundalive_sec
soundalive
cf65eb39-ce2f-48a8-a903-ceb818c06745
05227ea0-50bb-11e3-ac69-0002a5d5c51b
0b2dbc60-50bb-11e3-988b-0002a5d5c51b
libmysound_legacy.so
libmysound.so
mysound
dha
263a88e0-50b1-11e2-bcfd-0800200c9a66
37155c20-50bb-11e3-9fac-0002a5d5c51b
3ef69260-50bb-11e3-931e-0002a5d5c51b
libsamsungSoundbooster_tdm_legacy.so
tdm
beb1d058-916a-4adf-9cfe-54ee5ba8c4a5
libvolumemonitor_energy.so
volumemonitor
16311c29-bb53-4415-b7af-ae653e812de8
libmyspace.so
myspace
sa3d
3462a6e0-655a-11e4-8b67-0002a5d5c51b
1c91fca0-664a-11e4-b8c2-0002a5d5c51b
c7a84e61-eebe-4fcc-bc53-efcb841b4625
libLifevibes_lvverx.so
lmfv
fens
3b75f00-93ce-11e0-9fb8-0002a5d5c51b
d6dbf400-93ce-11e0-bcd7-0002a5d5c51b
df0afc20-93ce-11e0-98de-0002a5d5c51b
989d9460-413d-11e1-8b0d-0002a5d5c51b
cbcc5980-476d-11e1-82ee-0002a5d5c51b
libgearvr.so
vr360audio
vr3d
e6388202-e7a4-4c72-b68a-332eeeba269b"
#2RMV2="libdirac.so dirac e069d9e0-8329-11df-9168-0002a5d5c51b"
#3RMV3="libmisoundfx.so misoundfx 5b8e36a5-144a-4c38-b1d7-0002a5d5c51b"

# patch audio effects conf
if [ "$MODAEC" ]; then
  #2for RMVS2 in $RMV2; do
  #2  sed -i "s/$RMVS2/removed/g" $MODAEC
  #2done
  #3for RMVS3 in $RMV3; do
  #3  sed -i "s/$RMVS3/removed/g" $MODAEC
  #3done
  remove_conf
  sed -i "/^libraries {/a\  $NAME {\n    path $LIBPATH\/$LIB\n  }" $MODAEC
  sed -i "/^effects {/a\  $NAME {\n    library $NAME\n    uuid $UUID\n  }" $MODAEC
  sed -i "/^        ring_helper {/ {;N s/        ring_helper {\n        }//}" $MODAEC
  sed -i "/^        alarm_helper {/ {;N s/        alarm_helper {\n        }//}" $MODAEC
  sed -i "/^        music_helper {/ {;N s/        music_helper {\n        }//}" $MODAEC
  sed -i "/^        voice_helper {/ {;N s/        voice_helper {\n        }//}" $MODAEC
  sed -i "/^        notification_helper {/ {;N s/        notification_helper {\n        }//}" $MODAEC
  sed -i "/^        music_post_proc {/ {;N s/        music_post_proc {\n        }//}" $MODAEC
  sed -i "/^        voice_post_proc {/ {;N s/        voice_post_proc {\n        }//}" $MODAEC
  sed -i "/^        notification_post_proc {/ {;N s/        notification_post_proc {\n        }//}" $MODAEC
  sed -i "/^        dirac {/ {;N s/        dirac {\n        }//}" $MODAEC
  if ! grep -Eq '^output_session_processing {' $MODAEC; then
    sed -i -e '$a\
output_session_processing {\
    music {\
    }\
    ring {\
    }\
    alarm {\
    }\
    voice_call {\
    }\
    notification {\
    }\
}\' $MODAEC
  else
    if ! grep -Eq '^    notification {' $MODAEC; then
      sed -i "/^output_session_processing {/a\    notification {\n    }" $MODAEC
    fi
    if ! grep -Eq '^    voice_call {' $MODAEC; then
      sed -i "/^output_session_processing {/a\    voice_call {\n    }" $MODAEC
    fi
    if ! grep -Eq '^    alarm {' $MODAEC; then
      sed -i "/^output_session_processing {/a\    alarm {\n    }" $MODAEC
    fi
    if ! grep -Eq '^    ring {' $MODAEC; then
      sed -i "/^output_session_processing {/a\    ring {\n    }" $MODAEC
    fi
    if ! grep -Eq '^    music {' $MODAEC; then
      sed -i "/^output_session_processing {/a\    music {\n    }" $MODAEC
    fi
  fi
#m  sed -i "/^    music {/a\        $NAME {\n        }" $MODAEC
#r  sed -i "/^    ring {/a\        $NAME {\n        }" $MODAEC
#a  sed -i "/^    alarm {/a\        $NAME {\n        }" $MODAEC
#v  sed -i "/^    voice_call {/a\        $NAME {\n        }" $MODAEC
#n  sed -i "/^    notification {/a\        $NAME {\n        }" $MODAEC
fi

# patch audio effects xml
if [ "$MODAEX" ]; then
  #2for RMVS2 in $RMV2; do
  #2  sed -i "s/\"$RMVS2\"/\"removed\"/g" $MODAEX
  #2done
  #3for RMVS3 in $RMV3; do
  #3  sed -i "s/\"$RMVS3\"/\"removed\"/g" $MODAEX
  #3done
  remove_xml
  sed -i "/<libraries>/a\        <library name=\"$NAME\" path=\"$LIB\"\/>" $MODAEX
  sed -i "/<effects>/a\        <effect name=\"$NAME\" library=\"$NAME\" uuid=\"$UUID\"\/>" $MODAEX
  sed -i 's/<apply effect="ring_helper"\/>//g' $MODAEX
  sed -i 's/<apply effect="alarm_helper"\/>//g' $MODAEX
  sed -i 's/<apply effect="music_helper"\/>//g' $MODAEX
  sed -i 's/<apply effect="voice_helper"\/>//g' $MODAEX
  sed -i 's/<apply effect="notification_helper"\/>//g' $MODAEX
  sed -i 's/<apply effect="music_post_proc"\/>//g' $MODAEX
  sed -i 's/<apply effect="voice_post_proc"\/>//g' $MODAEX
  sed -i 's/<apply effect="notification_post_proc"\/>//g' $MODAEX
  sed -i 's/<apply effect="dirac"\/>//g' $MODAEX
  if ! grep -Eq '<postprocess>' $MODAEX || grep -Eq '<!-- Audio post processor' $MODAEX; then
    sed -i '/<\/effects>/a\
    <postprocess>\
        <stream type="music">\
        <\/stream>\
        <stream type="ring">\
        <\/stream>\
        <stream type="alarm">\
        <\/stream>\
        <stream type="voice_call">\
        <\/stream>\
        <stream type="notification">\
        <\/stream>\
    <\/postprocess>' $MODAEX
  else
    if ! grep -Eq '<stream type="notification">' $MODAEX || grep -Eq '<!-- YunMang.Xiao@PSW.MM.Dolby' $MODAEX; then
      sed -i "/<postprocess>/a\        <stream type=\"notification\">\n        <\/stream>" $MODAEX
    fi
    if ! grep -Eq '<stream type="voice_call">' $MODAEX; then
      sed -i "/<postprocess>/a\        <stream type=\"voice_call\">\n        <\/stream>" $MODAEX
    fi
    if ! grep -Eq '<stream type="alarm">' $MODAEX || grep -Eq '<!-- YunMang.Xiao@PSW.MM.Dolby' $MODAEX; then
      sed -i "/<postprocess>/a\        <stream type=\"alarm\">\n        <\/stream>" $MODAEX
    fi
    if ! grep -Eq '<stream type="ring">' $MODAEX || grep -Eq '<!-- YunMang.Xiao@PSW.MM.Dolby' $MODAEX; then
      sed -i "/<postprocess>/a\        <stream type=\"ring\">\n        <\/stream>" $MODAEX
    fi
    if ! grep -Eq '<stream type="music">' $MODAEX || grep -Eq '<!-- YunMang.Xiao@PSW.MM.Dolby' $MODAEX; then
      sed -i "/<postprocess>/a\        <stream type=\"music\">\n        <\/stream>" $MODAEX
    fi
  fi
#m  sed -i "/<stream type=\"music\">/a\            <apply effect=\"$NAME\"\/>" $MODAEX
#r  sed -i "/<stream type=\"ring\">/a\            <apply effect=\"$NAME\"\/>" $MODAEX
#a  sed -i "/<stream type=\"alarm\">/a\            <apply effect=\"$NAME\"\/>" $MODAEX
#v  sed -i "/<stream type=\"voice_call\">/a\            <apply effect=\"$NAME\"\/>" $MODAEX
#n  sed -i "/<stream type=\"notification\">/a\            <apply effect=\"$NAME\"\/>" $MODAEX
fi

# patch audio policy
if [ "$MODAP" ]; then
  sed -i 's/RAW/NONE/g' $MODAP
  sed -i 's/,raw//g' $MODAP
fi







