(

mount /data
mount -o rw,remount /data
MODDIR=${0%/*}
MODID=`echo "$MODDIR" | sed -n -e 's/\/data\/adb\/modules\///p'`
APP="`ls $MODPATH/system/priv-app` `ls $MODPATH/system/app`"
PKG="com.motorola.dolby.dolbyui
     com.dolby.daxservice
     com.motorola.motosignature.app"
     
# cleaning
for PKGS in $PKG; do
  rm -rf /data/user/*/$PKGS
done
for APPS in $APP; do
  rm -f `find /data/dalvik-cache /data/resource-cache -type f -name *$APPS*.apk`
done
rm -rf /metadata/magisk/"$MODID"
rm -rf /mnt/vendor/persist/magisk/"$MODID"
rm -rf /persist/magisk/"$MODID"
rm -rf /data/unencrypted/magisk/"$MODID"
rm -rf /cache/magisk/"$MODID"
rm -f /data/vendor/media/dax_sqlite3.db
resetprop -p --delete persist.vendor.audio_fx.current

# function
grep_cmdline() {
  REGEX="s/^$1=//p"
  cat /proc/cmdline | tr '[:space:]' '\n' | sed -n "$REGEX"
}
set_read_write() {
  if [ -d $BLOCK ]; then
    blockdev --setrw $BLOCK/system_ext$SLOT
    blockdev --setrw $BLOCK/vendor$SLOT
    blockdev --setrw $BLOCK/cust$SLOT
    blockdev --setrw $BLOCK/system$SLOT
  fi
}
restore() {
  for FILES in $FILE; do
    if [ -f $FILES.orig ]; then
      mv -f $FILES.orig $FILES
    fi
    if [ -f $FILES.bak ]; then
      mv -f $FILES.bak $FILES
    fi
  done
}

# boot mode
[ -z $BOOTMODE ] && ps | grep zygote | grep -qv grep && BOOTMODE=true
[ -z $BOOTMODE ] && ps -A | grep zygote | grep -qv grep && BOOTMODE=true
[ -z $BOOTMODE ] && BOOTMODE=false

# slot
SLOT=`grep_cmdline androidboot.slot_suffix`
if [ -z $SLOT ]; then
  SLOT=`grep_cmdline androidboot.slot`
  [ -z $SLOT ] || SLOT=_${SLOT}
fi

# magisk
if [ -d /sbin/.magisk ]; then
  MAGISKTMP=/sbin/.magisk
else
  MAGISKTMP=`find /dev -mindepth 2 -maxdepth 2 -type d -name .magisk`
fi

# system root
if [ -e $MAGISKTMP/mirror/system_root ] || [ -e /system_root ]; then
  SYSTEM_ROOT=true
else
  SYSTEM_ROOT=false
fi

# remount
if [ "$BOOTMODE" == true ]; then
  SYSTEMX=$MAGISKTMP/mirror/system_ext
  VENDOR=$MAGISKTMP/mirror/vendor
  if [ "$SYSTEM_ROOT" == true ]; then
    SYSTEM=$MAGISKTMP/mirror/system_root
  else
    SYSTEM=$MAGISKTMP/mirror/system
  fi
  BLOCK=/dev/block/bootdevice/by-name
  set_read_write
  BLOCK=/dev/block/mapper
  set_read_write
  blockdev --setrw $MAGISKTMP/block/system_ext
  blockdev --setrw $MAGISKTMP/block/vendor
  blockdev --setrw $MAGISKTMP/block/system_root
  blockdev --setrw $MAGISKTMP/block/system
  mount -o rw,remount $SYSTEMX
  mount -o rw,remount $VENDOR
  mount -o rw,remount $SYSTEM
  mount -o rw,remount /system_ext
  mount -o rw,remount /vendor
  if [ "$SYSTEM_ROOT" == true ]; then
    mount -o rw,remount /
  else
    mount -o rw,remount /system
  fi
else
  if [ "$SYSTEM_ROOT" == true ]; then
    SYSTEM=/system_root
  else
    SYSTEM=/system
  fi
  BLOCK=/dev/block/mapper
  if [ -d $BLOCK ]; then
    umount /system_ext
    umount /vendor
    umount $SYSTEM
    mount -o ro -t auto $BLOCK/system_ext$SLOT /system_ext
    mount -o ro -t auto $BLOCK/vendor$SLOT /vendor
    mount -o ro -t auto $BLOCK/system$SLOT $SYSTEM
    BLOCK=/dev/block/bootdevice/by-name
    set_read_write
    BLOCK=/dev/block/mapper
    set_read_write
    mount -o rw,remount -t auto $BLOCK/system_ext$SLOT /system_ext
    mount -o rw,remount -t auto $BLOCK/vendor$SLOT /vendor
    mount -o rw,remount -t auto $BLOCK/system$SLOT $SYSTEM
  else
    BLOCK=/dev/block/bootdevice/by-name
    set_read_write
    mount -o rw,remount /system_ext
    mount -o rw,remount /vendor
    mount -o rw,remount $SYSTEM
  fi
fi

# restore
if [ "$BOOTMODE" == true ]; then
  FILE=`find $SYSTEMX $VENDOR $SYSTEM /system_ext /vendor /system -type f -name manifest.xml -o -name *_hwservice_contexts -o -name *_file_contexts`
  restore
else
  FILE=`find /system_ext /vendor /system -type f -name manifest.xml -o -name *_hwservice_contexts -o -name *_file_contexts`
  restore
fi

# remount
if [ "$BOOTMODE" == true ]; then
  mount -o ro,remount $VENDOR
  mount -o ro,remount $SYSTEMX
  mount -o ro,remount $SYSTEM
  mount -o ro,remount /vendor
  mount -o ro,remount /system_ext
  if [ "$SYSTEM_ROOT" == true ]; then
    mount -o ro,remount /
  else
    mount -o ro,remount /system
  fi
fi

) 2>/dev/null


