(

mount /data
mount -o rw,remount /data
MODDIR=${0%/*}

# run
FILE=$MODDIR/sepolicy.sh
if [ -f $FILE ]; then
  sh $FILE
fi

# etc
if [ -d /sbin/.magisk ]; then
  MAGISKTMP=/sbin/.magisk
else
  MAGISKTMP=`find /dev -mindepth 2 -maxdepth 2 -type d -name .magisk`
fi
ETC=$MAGISKTMP/mirror/system/etc
VETC=$MAGISKTMP/mirror/system/vendor/etc
VOETC=$MAGISKTMP/mirror/system/vendor/odm/etc
MODETC=$MODDIR/system/etc
MODVETC=$MODDIR/system/vendor/etc
MODVOETC=$MODDIR/system/vendor/odm/etc

# conflict
AML=/data/adb/modules/aml
ACDB=/data/adb/modules/acdb
if [ -d $AML ] && [ -d $ACDB ]; then
  rm -rf $ACDB
fi
rm -f /data/adb/modules/*/system/app/MotoSignatureApp/.replace

# directory
SKU=`ls $VETC/audio | grep sku_`
if [ "$SKU" ]; then
  for SKUS in $SKU; do
    mkdir -p $MODVETC/audio/$SKUS
  done
fi
PROP=`getprop ro.build.product`
if [ -d $VETC/audio/"$PROP" ]; then
  mkdir -p $MODVETC/audio/"$PROP"
fi

# audio effects
NAME=*audio*effects*
rm -f `find $MODDIR/system -type f -name $NAME.conf -o -name $NAME.xml`
if [ ! -d $ACDB ] || [ -f $ACDB/disable ]; then
  AE=`find $ETC -maxdepth 1 -type f -name $NAME.conf -o -name $NAME.xml`
  VAE=`find $VETC -maxdepth 1 -type f -name $NAME.conf -o -name $NAME.xml`
  VOAE=`find $VOETC -maxdepth 1 -type f -name $NAME.conf -o -name $NAME.xml`
  cp -f $AE $MODETC
  cp -f $VAE $MODVETC
  cp -f $VOAE $MODVOETC
  if [ "$SKU" ]; then
    for SKUS in $SKU; do
      VSAE=`find $VETC/audio/$SKUS -maxdepth 1 -type f -name $NAME.conf -o -name $NAME.xml`
      cp -f $VSAE $MODVETC/audio/$SKUS
    done
  fi
  if [ -d $VETC/audio/"$PROP" ]; then
    VBAE=`find $VETC/audio/"$PROP" -maxdepth 1 -type f -name $NAME.conf -o -name $NAME.xml`
    cp -f $VBAE $MODVETC/audio/"$PROP"
  fi
fi

# audio policy
NAME=*policy*
rm -f `find $MODDIR/system -type f -name $NAME.conf -o -name $NAME.xml`
AP=`find $ETC -maxdepth 1 -type f -name $NAME.conf -o -name $NAME.xml`
VAP=`find $VETC -maxdepth 1 -type f -name $NAME.conf -o -name $NAME.xml`
VAAP=`find $VETC/audio -maxdepth 1 -type f -name $NAME.conf -o -name $NAME.xml`
VOAP=`find $VOETC -maxdepth 1 -type f -name $NAME.conf -o -name $NAME.xml`
cp -f $AP $MODETC
cp -f $VAP $MODVETC
cp -f $VAAP $MODVETC/audio
cp -f $VOAP $MODVOETC
if [ "$SKU" ]; then
  for SKUS in $SKU; do
    VSAP=`find $VETC/audio/$SKUS -maxdepth 1 -type f -name $NAME.conf -o -name $NAME.xml`
    cp -f $VSAP $MODVETC/audio/$SKUS
  done
fi
if [ -d $VETC/audio/"$PROP" ]; then
  VBAP=`find $VETC/audio/"$PROP" -maxdepth 1 -type f -name $NAME.conf -o -name $NAME.xml`
  cp -f $VBAP $MODVETC/audio/"$PROP"
fi

# media codecs
NAME=media_codecs.xml
rm -f $MODVETC/$NAME
DIR=$AML/system/vendor/etc
if [ -d $DIR ]; then
  cp -f $VETC/$NAME $DIR
else
  cp -f $VETC/$NAME $MODVETC
fi

# run
sh $MODDIR/.aml.sh

# directory
DIR=/data/vendor/media
if [ ! -d $DIR ]; then
  mkdir -p $DIR
fi
chmod 0770 $DIR
chown 1046.1013 $DIR
magiskpolicy --live "dontaudit vendor_media_data_file labeledfs filesystem associate"
magiskpolicy --live "allow     vendor_media_data_file labeledfs filesystem associate"
magiskpolicy --live "dontaudit init vendor_media_data_file dir relabelfrom"
magiskpolicy --live "allow     init vendor_media_data_file dir relabelfrom"
chcon u:object_r:vendor_media_data_file:s0 $DIR
magiskpolicy --live "type vendor_media_data_file"

# cleaning
FILE=$MODDIR/cleaner.sh
if [ -f $FILE ]; then
  sh $FILE
  rm -f $FILE
fi

) 2>/dev/null


