ui_print " "

# info
MODVER=`grep_prop version $MODPATH/module.prop`
MODVERCODE=`grep_prop versionCode $MODPATH/module.prop`
ui_print " ID=$MODID"
ui_print " Version=$MODVER"
ui_print " VersionCode=$MODVERCODE"
ui_print " MagiskVersion=$MAGISK_VER"
ui_print " MagiskVersionCode=$MAGISK_VER_CODE"
ui_print " "

# bit
if [ "$IS64BIT" != true ]; then
  abort "- This module is only for 64 bit devices."
else
  ui_print "- 64 bit"
  ui_print " "
fi

# sdk
NUM=28
if [ "$API" -lt $NUM ]; then
  ui_print "! Unsupported SDK $API. You have to upgrade your"
  ui_print "  Android version at least SDK API $NUM to use this module."
  abort
else
  ui_print "- SDK $API"
  ui_print " "
fi

# sepolicy.rule
FILE=$MODPATH/sepolicy.sh
DES=$MODPATH/sepolicy.rule
if [ -f $FILE ] && ! getprop | grep -Eq "sepolicy.sh\]: \[1"; then
  mv -f $FILE $DES
  sed -i 's/magiskpolicy --live "//g' $DES
  sed -i 's/"//g' $DES
fi

# .aml.sh
mv -f $MODPATH/aml.sh $MODPATH/.aml.sh

# mod ui
if getprop | grep -Eq "mod.ui\]: \[1"; then
  APP=MotoDolbyV3
  FILE=/sdcard/$APP.apk
  DIR=`find $MODPATH/system -type d -name $APP`
  ui_print "- Using modified UI apk..."
  if [ -f $FILE ]; then
    cp -f $FILE $DIR
    chmod 0644 $DIR/$APP.apk
    ui_print "  Applied"
  else
    ui_print "  ! There is no $FILE file."
    ui_print "    Please place the apk to your internal storage first"
    ui_print "    and reflash!"
  fi
  ui_print " "
fi

# cleaning
ui_print "- Cleaning..."
APP="`ls $MODPATH/system/priv-app` `ls $MODPATH/system/app`"
PKG="com.motorola.dolby.dolbyui
     com.dolby.daxservice
     com.motorola.motosignature.app"
for PKGS in $PKG; do
  if [ "$BOOTMODE" == true ]; then
    UNINSTALL=`pm uninstall $PKGS`
  fi
done
for APPS in $APP; do
  rm -f `find /data/dalvik-cache /data/resource-cache -type f -name *$APPS*.apk`
done
rm -f /data/vendor/media/dax_sqlite3.db
rm -f $MODPATH/LICENSE
rm -rf $MODPATH/unused
rm -rf /metadata/magisk/$MODID
rm -rf /mnt/vendor/persist/magisk/$MODID
rm -rf /persist/magisk/$MODID
rm -rf /data/unencrypted/magisk/$MODID
rm -rf /cache/magisk/$MODID
rm -f /data/system/dropbox/*
ui_print " "

# power save
PROP=`getprop power.save`
FILE=$MODPATH/system/etc/sysconfig/*
if [ "$PROP" == 1 ]; then
  ui_print "- $MODNAME will not be allowed in power save."
  ui_print "  It may save your battery but decreasing $MODNAME performance."
  for PKGS in $PKG; do
    sed -i "s/<allow-in-power-save package=\"$PKGS\"\/>//g" $FILE
    sed -i "s/<allow-in-power-save package=\"$PKGS\" \/>//g" $FILE
  done
  ui_print " "
fi

# function
conflict() {
for NAMES in $NAME; do
  rm -rf /data/adb/modules_update/$NAMES
  rm -f /data/adb/modules/$NAMES/update
  touch /data/adb/modules/$NAMES/remove
  sh /data/adb/modules/$NAMES/uninstall.sh
  rm -f /data/adb/modules/$NAMES/uninstall.sh
  rm -rf /metadata/magisk/$NAMES
  rm -rf /mnt/vendor/persist/magisk/$NAMES
  rm -rf /persist/magisk/$NAMES
  rm -rf /data/unencrypted/magisk/$NAMES
  rm -rf /cache/magisk/$NAMES
done
}

# conflict
NAME="dolbyatmos
        DolbyAtmos
        DolbyAudio
        dsplus
        Dolby"
conflict

# function
cleanup() {
sh $DIR/uninstall.sh
DIR=/data/adb/modules_update/$MODID
sh $DIR/uninstall.sh
}

# cleanup
DIR=/data/adb/modules/$MODID
FILE=$DIR/module.prop
if getprop | grep -Eq "dolby.cleanup\]: \[1"; then
  ui_print "- Cleaning-up $MODID data..."
  cleanup
  ui_print " "
elif [ -d $DIR ] && ! grep -Eq "$MODNAME" $FILE; then
  ui_print "- Different version detected"
  ui_print "  Cleaning-up $MODID data..."
  cleanup
  ui_print " "
fi

# function
permissive() {
SELINUX=`getenforce`
if [ "$SELINUX" == Enforcing ]; then
  setenforce 0
  SELINUX=`getenforce`
  if [ "$SELINUX" == Enforcing ]; then
    abort "! Your device can't be turned to Permissive state."
  fi
  setenforce 1
fi
sed -i '1i\
SELINUX=`getenforce`\
if [ "$SELINUX" == Enforcing ]; then\
  setenforce 0\
fi\' $MODPATH/post-fs-data.sh
}
backup() {
if [ ! -f $FILE.orig ] && [ ! -f $FILE.bak ]; then
  cp -f $FILE $FILE.orig
fi
}
patch_manifest() {
if [ -f $FILE ]; then
  backup
  ui_print "- Patching"
  ui_print "  $FILE"
  ui_print "  directly..."
  sed -i '/<manifest/a\
    <hal format="hidl">\
        <name>vendor.dolby.hardware.dms</name>\
        <transport>hwbinder</transport>\
        <version>1.0</version>\
        <interface>\
            <name>IDms</name>\
            <instance>default</instance>\
        </interface>\
        <fqname>@1.0::IDms/default</fqname>\
    </hal>' $FILE
  ui_print " "
fi
}
patch_hwservice() {
if [ -f $FILE ]; then
  backup
  ui_print "- Patching"
  ui_print "  $FILE"
  ui_print "  directly..."
  sed -i '1i\
vendor.dolby.hardware.dms::IDms u:object_r:hal_dms_hwservice:s0' $FILE
  ui_print " "
fi
}
check_patch() {
if ! grep -Eq "$CHECK" $FILE; then
  ui_print "! Patching failed. Please READ #troubleshootings!"
  abort
fi
}

# permissive
if getprop | grep -Eq "permissive.mode\]: \[1"; then
  ui_print "- Using permissive method"
  rm -f $MODPATH/sepolicy.rule
  permissive
  ui_print " "
elif getprop | grep -Eq "permissive.mode\]: \[2"; then
  ui_print "- Using both permissive and SE policy patch"
  permissive
  ui_print " "
fi

# magisk
if [ -d /sbin/.magisk ]; then
  MAGISKTMP=/sbin/.magisk
else
  MAGISKTMP=`find /dev -mindepth 2 -maxdepth 2 -type d -name .magisk`
fi

# function
set_read_write() {
if [ -d $BLOCK ]; then
  blockdev --setrw $BLOCK/system_ext$SLOT
  blockdev --setrw $BLOCK/vendor$SLOT
  blockdev --setrw $BLOCK/cust$SLOT
  blockdev --setrw $BLOCK/system$SLOT
fi
}

# remount
if [ "$BOOTMODE" == true ]; then
  SYSTEMX=$MAGISKTMP/mirror/system_ext
  VENDOR=$MAGISKTMP/mirror/vendor
  if [ "$SYSTEM_ROOT" == true ]; then
    SYSTEM=$MAGISKTMP/mirror/system_root
  else
    SYSTEM=$MAGISKTMP/mirror/system
  fi
  BLOCK=/dev/block/bootdevice/by-name
  set_read_write
  BLOCK=/dev/block/mapper
  set_read_write
  blockdev --setrw $MAGISKTMP/block/system_ext
  blockdev --setrw $MAGISKTMP/block/vendor
  blockdev --setrw $MAGISKTMP/block/system_root
  blockdev --setrw $MAGISKTMP/block/system
  mount -o rw,remount $SYSTEMX
  mount -o rw,remount $VENDOR
  mount -o rw,remount $SYSTEM
  mount -o rw,remount /system_ext
  mount -o rw,remount /vendor
  if [ "$SYSTEM_ROOT" == true ]; then
    mount -o rw,remount /
  else
    mount -o rw,remount /system
  fi
else
  if [ "$SYSTEM_ROOT" == true ]; then
    SYSTEM=/system_root
  else
    SYSTEM=/system
  fi
  BLOCK=/dev/block/mapper
  if [ -d $BLOCK ]; then
    umount /system_ext
    umount /vendor
    umount $SYSTEM
    mount -o ro -t auto $BLOCK/system_ext$SLOT /system_ext
    mount -o ro -t auto $BLOCK/vendor$SLOT /vendor
    mount -o ro -t auto $BLOCK/system$SLOT $SYSTEM
    BLOCK=/dev/block/bootdevice/by-name
    set_read_write
    BLOCK=/dev/block/mapper
    set_read_write
    mount -o rw,remount -t auto $BLOCK/system_ext$SLOT /system_ext
    mount -o rw,remount -t auto $BLOCK/vendor$SLOT /vendor
    mount -o rw,remount -t auto $BLOCK/system$SLOT $SYSTEM
  else
    BLOCK=/dev/block/bootdevice/by-name
    set_read_write
    mount -o rw,remount /system_ext
    mount -o rw,remount /vendor
    mount -o rw,remount $SYSTEM
  fi
fi

# patch manifest.xml
CHECK=@1.0::IDms/default
FILE="$MAGISKTMP/mirror/vendor/etc/vintf/manifest.xml
$MAGISKTMP/mirror/system/etc/vintf/manifest.xml
$MAGISKTMP/mirror/system_ext/etc/vintf/manifest.xml
/vendor/etc/vintf/manifest.xml
/system/etc/vintf/manifest.xml
/system/system_ext/etc/vintf/manifest.xml"
if ! grep -Eq "$CHECK" $FILE\
&& ! getprop | grep -Eq "dolby.skip.vendor\]: \[1"; then
  FILE=$MAGISKTMP/mirror/vendor/etc/vintf/manifest.xml
  patch_manifest
fi
if ! grep -Eq "$CHECK" $FILE\
&& ! getprop | grep -Eq "dolby.skip.system\]: \[1"; then
  FILE=$MAGISKTMP/mirror/system/etc/vintf/manifest.xml
  patch_manifest
fi
if ! grep -Eq "$CHECK" $FILE\
&& ! getprop | grep -Eq "dolby.skip.system_ext\]: \[1"; then
  FILE=$MAGISKTMP/mirror/system_ext/etc/vintf/manifest.xml
  patch_manifest
fi
if ! grep -Eq "$CHECK" $FILE\
&& ! getprop | grep -Eq "dolby.skip.vendor\]: \[1"; then
  FILE=/vendor/etc/vintf/manifest.xml
  patch_manifest
fi
if ! grep -Eq "$CHECK" $FILE\
&& ! getprop | grep -Eq "dolby.skip.system\]: \[1"; then
  FILE=/system/etc/vintf/manifest.xml
  patch_manifest
fi
if ! grep -Eq "$CHECK" $FILE\
&& ! getprop | grep -Eq "dolby.skip.system_ext\]: \[1"; then
  FILE=/system/system_ext/etc/vintf/manifest.xml
  patch_manifest
fi
if ! getprop | grep -Eq "dolby.skip.check\]: \[1"; then
  check_patch
fi

# patch hwservice contexts
CHECK=u:object_r:hal_dms_hwservice:s0
CHECK2=u:object_r:default_android_hwservice:s0
FILE="$MAGISKTMP/mirror/system_ext/etc/selinux/system_ext_hwservice_contexts
$MAGISKTMP/mirror/vendor/etc/selinux/vendor_hwservice_contexts
$MAGISKTMP/mirror/system/etc/selinux/plat_hwservice_contexts
/system/system_ext/etc/selinux/system_ext_hwservice_contexts
/vendor/etc/selinux/vendor_hwservice_contexts
/system/etc/selinux/plat_hwservice_contexts"
if ! grep -Eq "$CHECK" $FILE\
&& ! grep -Eq "$CHECK2" $FILE\
&& ! getprop | grep -Eq "dolby.skip.vendor\]: \[1"; then
  FILE=$MAGISKTMP/mirror/vendor/etc/selinux/vendor_hwservice_contexts
  patch_hwservice
fi
if ! grep -Eq "$CHECK" $FILE\
&& ! grep -Eq "$CHECK2" $FILE\
&& ! getprop | grep -Eq "dolby.skip.system\]: \[1"; then
  FILE=$MAGISKTMP/mirror/system/etc/selinux/plat_hwservice_contexts
  patch_hwservice
fi
if ! grep -Eq "$CHECK" $FILE\
&& ! grep -Eq "$CHECK2" $FILE\
&& ! getprop | grep -Eq "dolby.skip.system_ext\]: \[1"; then
  FILE=$MAGISKTMP/mirror/system_ext/etc/selinux/system_ext_hwservice_contexts
  patch_hwservice
fi
if ! grep -Eq "$CHECK" $FILE\
&& ! grep -Eq "$CHECK2" $FILE\
&& ! getprop | grep -Eq "dolby.skip.vendor\]: \[1"; then
  FILE=/vendor/etc/selinux/vendor_hwservice_contexts
  patch_hwservice
fi
if ! grep -Eq "$CHECK" $FILE\
&& ! grep -Eq "$CHECK2" $FILE\
&& ! getprop | grep -Eq "dolby.skip.system\]: \[1"; then
  FILE=/system/etc/selinux/plat_hwservice_contexts
  patch_hwservice
fi
if ! grep -Eq "$CHECK" $FILE\
&& ! grep -Eq "$CHECK2" $FILE\
&& ! getprop | grep -Eq "dolby.skip.system_ext\]: \[1"; then
  FILE=/system/system_ext/etc/selinux/system_ext_hwservice_contexts
  patch_hwservice
fi
#if ! getprop | grep -Eq "dolby.skip.check\]: \[1"; then
#  check_patch
#fi

# remount
if [ "$BOOTMODE" == true ]; then
  mount -o ro,remount $VENDOR
  mount -o ro,remount $SYSTEMX
  mount -o ro,remount $SYSTEM
  mount -o ro,remount /vendor
  mount -o ro,remount /system_ext
  if [ "$SYSTEM_ROOT" == true ]; then
    mount -o ro,remount /
  else
    mount -o ro,remount /system
  fi
fi

# check
NAME=_ZN7android23sp_report_stack_pointerEv
ui_print "- Checking $NAME function"
ui_print "  Please wait..."
if [ "$BOOTMODE" == true ]; then
  DIR=$MAGISKTMP/mirror/vendor
else
  DIR=/vendor
fi
if ! grep -Eq $NAME `find $DIR/lib* -type f -name *audio*.so` || getprop | grep -Eq "dolby.10\]: \[1"; then
  ui_print "  Using legacy libraries"
  cp -rf $MODPATH/system10/* $MODPATH/system
fi
rm -rf $MODPATH/system10
ui_print " "

# function
hide_oat() {
for APPS in $APP; do
  mkdir -p `find $MODPATH/system -type d -name $APPS`/oat
  touch `find $MODPATH/system -type d -name $APPS`/oat/.replace
done
}
replace_app() {
if [ -d $DIR ]; then
  mkdir -p $MODDIR
  touch $MODDIR/.replace
fi
}
hide_app() {
if [ "$BOOTMODE" == true ]; then
  DIR=$MAGISKTMP/mirror/system/app/$APPS
else
  DIR=/system/app/$APPS
fi
MODDIR=$MODPATH/system/app/$APPS
replace_app
if [ "$BOOTMODE" == true ]; then
  DIR=$MAGISKTMP/mirror/system/priv-app/$APPS
else
  DIR=/system/priv-app/$APPS
fi
MODDIR=$MODPATH/system/priv-app/$APPS
replace_app
if [ "$BOOTMODE" == true ]; then
  DIR=$MAGISKTMP/mirror/product/app/$APPS
else
  DIR=/product/app/$APPS
fi
MODDIR=$MODPATH/system/product/app/$APPS
replace_app
if [ "$BOOTMODE" == true ]; then
  DIR=$MAGISKTMP/mirror/product/priv-app/$APPS
else
  DIR=/product/priv-app/$APPS
fi
MODDIR=$MODPATH/system/product/priv-app/$APPS
replace_app
if [ "$BOOTMODE" == true ]; then
  DIR=$MAGISKTMP/mirror/product/preinstall/$APPS
else
  DIR=/product/preinstall/$APPS
fi
MODDIR=$MODPATH/system/product/preinstall/$APPS
replace_app
if [ "$BOOTMODE" == true ]; then
  DIR=$MAGISKTMP/mirror/system_ext/app/$APPS
else
  DIR=/system/system_ext/app/$APPS
fi
MODDIR=$MODPATH/system/system_ext/app/$APPS
replace_app
if [ "$BOOTMODE" == true ]; then
  DIR=$MAGISKTMP/mirror/system_ext/priv-app/$APPS
else
  DIR=/system/system_ext/priv-app/$APPS
fi
MODDIR=$MODPATH/system/system_ext/priv-app/$APPS
replace_app
}
check_app() {
if [ "$BOOTMODE" == true ]; then
  for APPS in $APP; do
    FILE=`find $MAGISKTMP/mirror/system_root/system\
               $MAGISKTMP/mirror/system_root/product\
               $MAGISKTMP/mirror/system_root/system_ext\
               $MAGISKTMP/mirror/system\
               $MAGISKTMP/mirror/product\
               $MAGISKTMP/mirror/system_ext -type f -name $APPS.apk`
    if [ "$FILE" ]; then
      ui_print "  Checking $APPS.apk"
      ui_print "  Please wait..."
      if grep -Eq $UUID $FILE; then
        ui_print "  Your $APPS.apk will be hidden"
        hide_app
      fi
    fi
  done
fi
}
detect_soundfx() {
if [ "$BOOTMODE" == true ]; then
  if dumpsys media.audio_flinger | grep -Eq $UUID; then
    ui_print "- $NAME is detected"
    ui_print "  It may conflicting with this module"
    ui_print "  Read Github Troubleshootings to disable it"
    ui_print " "
  fi
fi
}

# hide
hide_oat
APP="DaxUI OPSoundTuner DolbyAtmos"
for APPS in $APP; do
  hide_app
done
if getprop | grep -Eq "disable.dirac\]: \[1" || getprop | grep -Eq "disable.misoundfx\]: \[1"; then
  APP=MiSound
  for APPS in $APP; do
    hide_app
  done
fi

# dirac
FILE=$MODPATH/.aml.sh
APP="XiaomiParts
     ZenfoneParts
     ZenParts
     GalaxyParts"
NAME='dirac soundfx'
UUID=e069d9e0-8329-11df-9168-0002a5d5c51b
if getprop | grep -Eq "disable.dirac\]: \[1"; then
  ui_print "- $NAME will be disabled"
  sed -i 's/#2//g' $FILE
  check_app
  ui_print " "
else
  detect_soundfx
fi

# misoundfx
NAME=misoundfx
UUID=5b8e36a5-144a-4c38-b1d7-0002a5d5c51b
if getprop | grep -Eq "disable.misoundfx\]: \[1"; then
  ui_print "- $NAME will be disabled"
  sed -i 's/#3//g' $FILE
  check_app
  ui_print " "
else
  detect_soundfx
fi

# stream mode
PROP=`getprop stream.mode`
if echo "$PROP" | grep -Eq m; then
  ui_print "- Activating music stream..."
  sed -i 's/#m//g' $FILE
  sed -i 's/musicstream=/musicstream=true/g' $MODPATH/acdb.conf
  ui_print " "
else
  APP="AudioFX MusicFX"
  for APPS in $APP; do
    hide_app
  done
fi
if echo "$PROP" | grep -Eq r; then
  ui_print "- Activating ring stream..."
  sed -i 's/#r//g' $FILE
  ui_print " "
fi
if echo "$PROP" | grep -Eq a; then
  ui_print "- Activating alarm stream..."
  sed -i 's/#a//g' $FILE
  ui_print " "
fi
if echo "$PROP" | grep -Eq v; then
  ui_print "- Activating voice_call stream..."
  sed -i 's/#v//g' $FILE
  ui_print " "
fi
if echo "$PROP" | grep -Eq n; then
  ui_print "- Activating notification stream..."
  sed -i 's/#n//g' $FILE
  ui_print " "
fi

# settings
FILE=$MODPATH/system/vendor/etc/dolby/dax-default.xml
PROP=`getprop dolby.bass`
if [ "$PROP" -gt 0 ]; then
  ui_print "- Enable bass enhancer for all profiles..."
  sed -i 's/bass-enhancer-enable value="false"/bass-enhancer-enable value="true"/g' $FILE
  ui_print "- Changing bass enhancer boost values to $PROP for all profiles..."
  ROW=`grep bass-enhancer-boost $FILE | sed 's/<bass-enhancer-boost value="0"\/>//p'`
  echo $ROW > $TMPDIR/test
  sed -i 's/<bass-enhancer-boost value="//g' $TMPDIR/test
  sed -i 's/"\/>//g' $TMPDIR/test
  ROW=`cat $TMPDIR/test`
  ui_print "  (Default values: $ROW)"
  for ROWS in $ROW; do
    sed -i "s/bass-enhancer-boost value=\"$ROWS\"/bass-enhancer-boost value=\"$PROP\"/g" $FILE
  done
elif [ "$PROP" == true ]; then
  ui_print "- Enable bass enhancer for all profiles..."
  sed -i 's/bass-enhancer-enable value="false"/bass-enhancer-enable value="true"/g' $FILE
elif [ "$PROP" == default ]; then
  ui_print "- Using default settings for bass enhancer"
else
  ui_print "- Disable bass enhancer for all profiles..."
  sed -i 's/bass-enhancer-enable value="true"/bass-enhancer-enable value="false"/g' $FILE
fi
if getprop | grep -Eq "dolby.virtualizer\]: \[1"; then
  ui_print "- Enable virtualizer for all profiles..."
  sed -i 's/virtualizer-enable value="false"/virtualizer-enable value="true"/g' $FILE
elif getprop | grep -Eq "dolby.virtualizer\]: \[0"; then
  ui_print "- Disable virtualizer for all profiles..."
  sed -i 's/virtualizer-enable value="true"/virtualizer-enable value="false"/g' $FILE
fi
if getprop | grep -Eq "dolby.volumeleveler\]: \[1"; then
  ui_print "- Using default volume leveler settings"
elif getprop | grep -Eq "dolby.volumeleveler\]: \[2"; then
  ui_print "- Enable volume leveler for all profiles..."
  sed -i 's/volume-leveler-enable value="false"/volume-leveler-enable value="true"/g' $FILE
else
  ui_print "- Disable volume leveler for all profiles..."
  sed -i 's/volume-leveler-enable value="true"/volume-leveler-enable value="false"/g' $FILE
fi
ui_print " "

# audio rotation
PROP=`getprop audio.rotation`
FILE=$MODPATH/service.sh
if [ "$PROP" == 1 ]; then
  ui_print "- Activating ro.audio.monitorRotation=true"
  sed -i '1i\
resetprop ro.audio.monitorRotation true' $FILE
  ui_print " "
fi

# function
file_check_vendor() {
for NAMES in $NAME; do
  if [ "$BOOTMODE" == true ]; then
    FILE64=$MAGISKTMP/mirror/vendor/lib64/$NAMES
    FILE=$MAGISKTMP/mirror/vendor/lib/$NAMES
  else
    FILE64=/vendor/lib64/$NAMES
    FILE=/vendor/lib/$NAMES
  fi
  if [ -f $FILE64 ]; then
    ui_print "- Detected"
    ui_print "  $FILE64"
    rm -f $MODPATH/system/vendor/lib64/$NAMES
    ui_print " "
  fi
  if [ -f $FILE ]; then
    ui_print "- Detected"
    ui_print "  $FILE"
    rm -f $MODPATH/system/vendor/lib/$NAMES
    ui_print " "
  fi
done
}

# check
NAME="libstagefrightdolby.so libstagefright_soft_ddpdec.so"
file_check_vendor

# permission
ui_print "- Setting permission..."
FILE=$MODPATH/system/vendor/bin/hw/*
chmod 0755 $FILE
DIR=`find $MODPATH/system/vendor -type d`
for DIRS in $DIR; do
  chown 0.2000 $DIRS
done
chown 0.2000 $FILE
magiskpolicy --live "dontaudit { hal_dms_default_exec vendor_file vendor_configs_file } labeledfs filesystem associate"
magiskpolicy --live "allow     { hal_dms_default_exec vendor_file vendor_configs_file } labeledfs filesystem associate"
magiskpolicy --live "dontaudit init { vendor_file vendor_configs_file } dir relabelfrom"
magiskpolicy --live "allow     init { vendor_file vendor_configs_file } dir relabelfrom"
magiskpolicy --live "dontaudit init { hal_dms_default_exec vendor_file vendor_configs_file } file relabelfrom"
magiskpolicy --live "allow     init { hal_dms_default_exec vendor_file vendor_configs_file } file relabelfrom"
chcon -R u:object_r:vendor_file:s0 $MODPATH/system/vendor
chcon -R u:object_r:vendor_configs_file:s0 $MODPATH/system/vendor/etc
chcon -R u:object_r:vendor_configs_file:s0 $MODPATH/system/vendor/odm/etc
chcon u:object_r:hal_dms_default_exec:s0 $FILE
ui_print " "

# vendor_overlay
DIR=/product/vendor_overlay
if [ -d $DIR ]; then
  ui_print "- Fixing $DIR mount..."
  cp -rf $DIR/*/* $MODPATH/system/vendor
  ui_print " "
fi

# uninstaller
NAME=DolbyModuleUninstaller.zip
ui_print "- Flash /sdcard/$NAME"
ui_print "  via recovery if you got bootloop"
cp -f $MODPATH/$NAME /sdcard
rm -f $MODPATH/$NAME
ui_print " "









