#!/bin/sh
BASEDIR="$(dirname $(readlink -f "$0"))"

lock_val(){
    for p in $2; do
        if [ -f "$p" ]; then
            chown root:root "$p"
            chmod 0666 "$p"
            echo "$1" >"$p"
            chmod 0444 "$p"
        fi
    done
}

wait_until_login() {
    # in case of /data encryption is disabled
    while [ "$(getprop sys.boot_completed)" != "1" ]; do
        sleep 1
    done
    # we doesn't have the permission to rw "/sdcard" before the user unlocks the screen
    local test_file="/sdcard/Android/.THERMAL_PERMISSION_TEST"
    true >"$test_file"
    while [ ! -f "$test_file" ]; do
        true >"$test_file"
        sleep 1
    done
    rm "$test_file"
}

current(){
    #impose restrictions on max electricity
    #tacitly approve is 12500ma
   if [ -f $BASEDIR/max.conf ]; then
      bat="/sys/class/power_supply/battery/constant_charge_current"
      sysfsbat="$(cat $BASEDIR/max.conf)"
      lock_val $sysfsbat $bat
      cat $bat > $BASEDIR/当前电流.txt
   else 
      echo "12500000" > $BASEDIR/max.conf
      current
   fi
}

Support_apps(){
   #need some apps to support
   app="com.xiaomi.xmsf
   com.miui.powerkeeper
   com.xiaomi.joyose"
   for i in $app; do
        pm clear $i
   done
}

use_cloud_interface(){
    chattr -R -i /data/vendor/thermal
    rm -rf /data/vendor/thermal/*
    mkdir -p /data/vendor/thermal/config
    cp -rf $BASEDIR/thermal/* /data/vendor/thermal/config
    chmod 0666 /data/vendor/thermal/config/*
    chattr +i /data/vendor/thermal/config
}



SutoLiu_nmsl(){
    #delete conflict modules
    MODS_PATH="/data/adb/modules"
    s="Sut"
    b="oLiu"
    for i in $(ls $MODS_PATH); do
        if [[ ! -z $(grep author=$s$b $MODS_PATH/$i/module.prop) ]]; then
            chattr -R -i $MODS_PATH/$i
            rm -rf $MODS_PATH/$i
        fi
    done
}



disable_userspace_thermal(){
    # prohibit mi_thermald use cpu thermal interface
    for i in $(seq 0 7); do
        local maxfreq="$(cat /sys/devices/system/cpu/cpu$i/cpufreq/cpuinfo_max_freq)"
        [ "$maxfreq" -gt "0" ] && lock_val "cpu$i $maxfreq" /sys/devices/virtual/thermal/thermal_message/cpu_limits
    done
}

restart_mi_thermald(){
        stop mi_thermald
        stop thermald
        nohup /dev/*/.magisk/mirror/vendor/bin/mi_thermald > /dev/null 2>&1 &
}


   
        wait_until_login
        Support_apps
        use_cloud_interface
        current
        restart_mi_thermald
        disable_userspace_thermal
        SutoLiu_nmsl