#!/system/bin/sh

LOG_FILE="/cache/auto_format_data.log"
UNLOCKED_THRESHOLD=$((48 * 60 * 60)) # 48小时的秒数

while true; do
    # 获取最后一次解锁时间
    last_unlock_time=$(dumpsys locksettings | grep 'mLastAuthenticatedTime' | cut -d '=' -f 2)
    
    # 获取当前时间
    current_time=$(date +%s)
    
    # 计算时间差
    time_diff=$((current_time - last_unlock_time))
    
    if [ $time_diff -ge $UNLOCKED_THRESHOLD ]; then
        # 超过时间阈值，格式化 /data
/system/bin/mke2fs /data
    fi
    
    sleep 3600 # 每小时检查一次
done
