#!/system/bin/sh

echo ""
echo "∞————————————————————————∞"
echo ""
echo "- 设置Apktools 中……"
mkdir -p /data/local/Apktool
unzip -p "$ZIPFILE" 'apktools.tar.xz' | tar xJ -C /data/local/Apktool >/dev/null
chmod -R 777 /data/local/Apktool
test ! -e /data/data/per.pqy.openjdk && {
	cp -rf /data/local/Apktool/per.pqy.openjdk /data/data
	chmod -R 777 /data/data/per.pqy.openjdk
}

echo "- 配置完成！"

apktool=/data/local/Apktool/apktool/apktool.sh
zipalign=/data/local/Apktool/apktool/openjdk/bin/zipalign

echo "- 反编译文件中……"
MIUIpower=$(pm path com.miui.powerkeeper | cut -d ':' -f2 )
MIUIsyspower="/system/app/PowerKeeper/PowerKeeper.apk"
MIUIsyspowerdir="$MODPATH${MIUIsyspower%/*}"
mkdir -p $MIUIsyspowerdir $MODPATH/apk
cp -rf $MIUIpower $MODPATH/apk/base.apk

cd $MODPATH/apk
$apktool d -q -r -f -m $MODPATH/apk/base.apk

echo "- 修改文件中……"
key_source $MODPATH/sed.sh

echo "- 输出修改文件中……"
cd $MODPATH/apk
$apktool b -q -f -c $MODPATH/apk/base -o PowerKeeper.apk
echo "- 对apk文件zip对齐优化中……"
$zipalign -f 4 $MODPATH/apk/PowerKeeper.apk $MODPATH$MIUIsyspower
echo "- 修改完成！" 
echo ""

echo "- 清理应用缓存和无用文件……"
rm -rf /data/system/package_cache/* /data/local/Apktool /data/data/per.pqy.openjdk $MODPATH/apk $MODPATH/apktools.tar.xz
dda=/data/dalvik-cache/arm
test -d $dda"64" && dda=$dda"64"
rm -f $dda/system@*@"PowerKeeper"* 
echo "- 完成！"

echo ""
echo "∞————————————————————————∞"

