file=${0%/*}
file_log=/sdcard/Android/Apower/日志.txt
file_path=$file/Variable.prop
time_charge=$(grep 'ti_charge' "$file_path" | awk -F'=' '{print $2}')
battery_charge=$(grep 'ba_charge' "$file_path" | awk -F'=' '{print $2}')
battery=$(cat /sys/class/power_supply/battery/capacity)
time=$(date +"%Y-%m-%d %H:%M:%S")
diff_battery=$((battery - battery_charge))
timestamp_charge=$(date -d "$time_charge" +%s)
timestamp=$(date -d "$time" +%s)
diff=$(($timestamp - $timestamp_charge))
minutes=$((diff / 60))
seconds=$((diff % 60))
hours=$((minutes / 60))
minutes=$((minutes % 60))
diff_time="$hours时$minutes分$seconds秒"
temp=$(echo "scale=1; $(cat /sys/class/power_supply/battery/temp) / 10" | bc -l)
temp_start=$(grep 'temp' "$file/Variable.prop" | awk -F'=' '{print $2}')
num1=$(echo "$temp_start" | bc)
num2=$(echo "$temp" | bc)
if [ $(echo "$num1 > $num2" | bc -l) = 1 ]; then
    q="这次充电温度降低了"
    diff=$(echo "$num1 - $num2" | bc)
else
    if [ "$num1" = "$num2" ]; then
    q=1
    else
        q="这次充电温度升高了"
        diff=$(echo "$num2 - $num1" | bc)
    fi
fi
if [ ${#diff} -eq 2 ]; then
    temp_diff="$q""0$diff℃"
elif [ "$num1" = "$num2" ]; then
    temp_diff="这次充电温度没有变化"
else
    temp_diff="$q""$diff℃"
fi
frequency=$(grep 'frequency' "$file_path" | awk -F'=' '{print $2}')
frequency_new=$(($frequency + 1))
echo "$time已停止充电，本次统计充电时长:$diff_time，当前温度:$temp℃，电量从$battery_charge%充到了$battery%，一共充了$diff_battery%，$temp_diff，今日充电次数:$frequency_new" >> $file_log
sed -i "/ti_charge=/s/.*/ti_charge=$time/" $file_path
sed -i "/ba_charge=/s/.*/ba_charge=$battery/" $file_path
sed -i "/time=/s/.*/time=$time/" $file_path
sed -i "/frequency=/s/.*/frequency=$frequency_new/" $file_path