#!/system/bin/sh
MODDIR=${0%/*}
System_Activation()
{
	local wait_start=0
	until [[ $(getprop sys.boot_completed) -eq 1 ]]; do
		local wait_start=$((${wait_start} + 1))
		[[ ${wait_start} -ge 150 ]] && exit 1
		sleep 2
	done
}
System_Activation
sdcard_rw()
{
	local test_file="/sdcard/Android/.TEST_FILE"
	touch $test_file
	while [[ ! -f $test_file ]]; do
		touch $test_file
		sleep 1
	done
	rm $test_file
}
sdcard_rw

file=${0%/*}
file_log=/sdcard/Android/Apower/日志.txt
file_path=$file/tool/Variable.prop
reboot=$(grep 'reboot' "$file_path" | awk -F'=' '{print $2}')
reboot_new=$(($reboot + 1))
echo "$(date +"%Y-%m-%d %H:%M:%S")时重启开机，今日已重启$reboot_new次" >> $file_log
sed -i "/reboot=/s/.*/reboot=$reboot_new/" $file_path
while true; do
time_from_file=$(cat $file_path | grep time | cut -d'=' -f2)
current_date=$(date '+%Y-%m-%d')
file_date=$(date -d "$time_from_file" '+%Y-%m-%d')
if [ "$current_date" = "$file_date" ]; then
    q=1
else
    sed -i "/reboot=/s/.*/reboot=0/" $file_path
    sed -i "/frequency=/s/.*/frequency=0/" $file_path
fi
sh $file/tool/tool.sh
sleep 5
done
