file=${0%/*}
file_log=/sdcard/Android/Apower/日志.txt
file_magisk_log=$(dirname "$file")/module.prop
file_path=$file/Variable.prop
battery=$(cat /sys/class/power_supply/battery/capacity)
time=$(date +"%Y-%m-%d %H:%M:%S")
temp=$(echo "scale=1; $(cat /sys/class/power_supply/battery/temp) / 10" | bc -l)
voltage=$(cat /sys/class/power_supply/battery/voltage_now)
current=$(cat /sys/class/power_supply/battery/current_now)
voltage=$(echo "$voltage / 1000" | bc)
current=$(echo "$current / 1000" | bc)
power=$((voltage * current /10000))
Charge=$(cat /sys/class/power_supply/battery/status)
screen=$(dumpsys window policy | grep "mInputRestricted" | cut -d= -f2)
if [ "$screen" = "false" ]; then
    screen="亮屏"
else
    screen="息屏"
fi
time_t=$(grep 'time' "$file_path" | awk -F'=' '{print $2}')
time_stamp=$(date -d "$time_t" +%s)
current_time_stamp=$(date -d "$time" +%s)
time_diff=$((current_time_stamp - time_stamp))
hours=$((time_diff / 3600))
minutes=$((time_diff % 3600 / 60))
seconds=$((time_diff % 60))
diff="$hours时$minutes分$seconds秒"
if [ "$Charge" == "Discharging" ]
then
    power=$(echo "scale=2; $power / 100" | bc -l)
    if [ ${#power} -eq 3 ]; then
    power="0$power"
    else
    power="$power"
    fi
    battery_log=$(grep 'battery' "$file_path" | awk -F'=' '{print $2}')
    battery_diff=$((battery_log - battery))
    log="↓状态:正在放电，$screen，$time，当前电量:$battery%，$diff耗电$battery_diff%，功耗:$power"w"，温度:$temp℃"
else
    power=$((power * -1))
    power=$(echo "scale=2; $power / 100" | bc -l)
    battery_log=$(grep 'battery' "$file_path" | awk -F'=' '{print $2}')
    battery_diff=$((battery - battery_log))
    log="↑状态:正在充电，$screen，$time，当前电量:$battery%，$diff充电$battery_diff%，功率:$power"w"，温度:$temp℃"
fi
echo "$log" >> $file_log
sed -i "/time=/s/.*/time=$time/" $file_path
sed -i "/battery=/s/.*/battery=$battery/" $file_path
sed -i "/description=/s/.*/description=$log/" $file_magisk_log
