file=${0%/*}
file_log=/sdcard/Android/Apower/日志.txt
file_path=$file/Variable.prop
time_charge=$(grep 'ti_charge' "$file_path" | awk -F'=' '{print $2}')
battery_charge=$(grep 'ba_charge' "$file_path" | awk -F'=' '{print $2}')
battery=$(cat /sys/class/power_supply/battery/capacity)
time=$(date +"%Y-%m-%d %H:%M:%S")
diff_battery=$((battery_charge - battery))
timestamp_charge=$(date -d "$time_charge" +%s)
timestamp=$(date -d "$time" +%s)
diff=$(($timestamp - $timestamp_charge))
minutes=$((diff / 60))
seconds=$((diff % 60))
hours=$((minutes / 60))
minutes=$((minutes % 60))
diff="$hours时$minutes分$seconds秒"
temp=$(echo "scale=1; $(cat /sys/class/power_supply/battery/temp) / 10" | bc -l)
echo "$time已开始充电，本次统计耗电时长:$diff，当前温度:$temp℃，电量从$battery_charge%掉到了$battery%，一共掉了$diff_battery%" >> $file_log
sed -i "/temp=/s/.*/temp=$temp/" $file_path
sed -i "/ti_charge=/s/.*/ti_charge=$time/" $file_path
sed -i "/ba_charge=/s/.*/ba_charge=$battery/" $file_path
sed -i "/time=/s/.*/time=$time/" $file_path
