# store
MODID=DolbyAtmos
if [ -d /sbin/.magisk ]; then
  MAGISKTMP=/sbin/.magisk
else
  MAGISKTMP=`find /dev -mindepth 2 -maxdepth 2 -type d -name .magisk`
fi
if [ -d $MAGISKTMP/mirror/system_root ]; then
  SYSTEM=$MAGISKTMP/mirror/system_root
else
  SYSTEM=$MAGISKTMP/mirror/system
fi
VENDOR=$MAGISKTMP/mirror/vendor
restore() {
  for FILES in $FILE; do
    mv -f $FILES.orig $FILES
    mv -f $FILES.bak $FILES
  done
}
APP1=DaxUI
APP2=daxService
PKG1=com.dolby.daxappui
PKG2=com.dolby.service
PKGCACHE=/data/system/package_cache

# restore system|vendor
mount -o rw,remount $SYSTEM
mount -o rw,remount $VENDOR
FILE=`find $SYSTEM $VENDOR -type f -name manifest.xml`
restore
FILE=`find $SYSTEM $VENDOR -type f -name *_hwservice_contexts`
restore
FILE=`find $SYSTEM $VENDOR -type f -name *_file_contexts`
restore
mount -o ro,remount $SYSTEM
mount -o ro,remount $VENDOR

# cleaning
rm -f `find /data/dalvik-cache -type f -name *$APP1*`
rm -f `find /data/dalvik-cache -type f -name *$APP2*`
rm -f `find $PKGCACHE -type f -name $APP1*`
rm -f `find $PKGCACHE -type f -name $APP2*`
rm -f `find $PKGCACHE -type f -name $PKG1*`
rm -f `find $PKGCACHE -type f -name $PKG2*`
rm -rf /data/vendor/dolby
rm -rf /metadata/magisk/$MODID
rm -rf /mnt/vendor/persist/magisk/$MODID
rm -rf /persist/magisk/$MODID
rm -rf /data/unencrypted/magisk/$MODID
rm -rf /cache/magisk/$MODID




