MODDIR=${0%/*}
MODID=DolbyAtmos

# aml
if [ -d /data/adb/modules/aml ]; then
  AML=/data/adb/aml/$MODID/system
  if [ ! -d $AML/etc ]; then
    mkdir -p $AML/etc
  fi
  if [ ! -d $AML/vendor/etc ]; then
    mkdir -p $AML/vendor/etc
  fi
fi

# etc
if [ -d /sbin/.magisk ]; then
  MAGISKTMP=/sbin/.magisk
else
  MAGISKTMP=`find /dev -mindepth 2 -maxdepth 2 -type d -name .magisk`
fi
ETC=$MAGISKTMP/mirror/system/etc
VETC=$MAGISKTMP/mirror/vendor/etc
METC=$MODDIR/system/etc
MVETC=$MODDIR/system/vendor/etc

# acdb
ACDB=/data/adb/modules/acdb
rm -f `find $MODDIR/system -type f -name *audio*effects*`
if [ ! -d $ACDB ] || [ -f $ACDB/disable ]; then

  # destinations
  AEC=`find $ETC -type f -name *audio*effects*.conf`
  VAEC=`find $VETC -type f -name *audio*effects*.conf`
  AEX=`find $ETC -type f -name *audio*effects*.xml`
  VAEX=`find $VETC -type f -name *audio*effects*.xml`
  cp -f $AEC $METC
  cp -f $VAEC $MVETC
  cp -f $AEX $METC
  cp -f $VAEX $MVETC
  MAEC=`find $MODDIR/system -type f -name *audio*effects*.conf`
  MAEX=`find $MODDIR/system -type f -name *audio*effects*.xml`
  LIBPATH="\/vendor\/lib\/soundfx"

  # store
  NAME=vqe
  LIB=libswvqe.so
  UUID=64a0f614-7fa4-48b8-b081-d59dc954616f

  # patch audio effects conf
  if echo $MAEC | grep -Eq conf; then
    sed -i "/^libraries {/a\  $NAME {\n    path $LIBPATH\/$LIB\n  }" $MAEC
    sed -i "/^effects {/a\  $NAME {\n    library $NAME\n    uuid $UUID\n  }" $MAEC
  fi

  # patch audio effects xml
  if echo $MAEX | grep -Eq xml; then
    sed -i "/<libraries>/a\        <library name=\"$NAME\" path=\"$LIB\"\/>" $MAEX
    sed -i "/<effects>/a\        <effect name=\"$NAME\" library=\"$NAME\" uuid=\"$UUID\"\/>" $MAEX
  fi

  # store
  NAME=dolbyatmos
  LIB=libatmos.so
  UUID=74697567-7261-6564-6864-65726f206678
  #1RMV=dirac
  #1LIBRMV=libdirac.so
  #1UUIDRMV=e069d9e0-8329-11df-9168-0002a5d5c51b
  #2RMV2=misoundfx
  #2LIBRMV2=libmisoundfx.so
  #2UUIDRMV2=5b8e36a5-144a-4c38-b1d7-0002a5d5c51b

  # patch audio effects conf
  if echo $MAEC | grep -Eq conf; then
    #1sed -i "s/$LIBRMV/removed/g" $MAEC
    #1sed -i "s/$RMV/removed/g" $MAEC
    #1sed -i "s/$UUIDRMV/removed/g" $MAEC
    #2sed -i "s/$LIBRMV2/removed/g" $MAEC
    #2sed -i "s/$RMV2/removed/g" $MAEC
    #2sed -i "s/$UUIDRMV2/removed/g" $MAEC
    sed -i "/^libraries {/a\  $NAME {\n    path $LIBPATH\/$LIB\n  }" $MAEC
    sed -i "/^effects {/a\  $NAME {\n    library $NAME\n    uuid $UUID\n  }" $MAEC
    sed -i "/^        ring_helper {/ {;N s/        ring_helper {\n        }/\n/}" $MAEC
    sed -i "/^        alarm_helper {/ {;N s/        alarm_helper {\n        }/\n/}" $MAEC
    sed -i "/^        music_helper {/ {;N s/        music_helper {\n        }/\n/}" $MAEC
    sed -i "/^        voice_helper {/ {;N s/        voice_helper {\n        }/\n/}" $MAEC
    sed -i "/^        notification_helper {/ {;N s/        notification_helper {\n        }/\n/}" $MAEC
    sed -i "/^        music_post_proc {/ {;N s/        music_post_proc {\n        }/\n/}" $MAEC
    sed -i "/^        voice_post_proc {/ {;N s/        voice_post_proc {\n        }/\n/}" $MAEC
    sed -i "/^        notification_post_proc {/ {;N s/        notification_post_proc {\n        }/\n/}" $MAEC
    sed -i "/^        sa3d {/ {;N s/        sa3d {\n        }/\n/}" $MAEC
    sed -i "/^        fens {/ {;N s/        fens {\n        }/\n/}" $MAEC
    sed -i "/^        lmfv {/ {;N s/        lmfv {\n        }/\n/}" $MAEC
    sed -i "/^        removed {/ {;N s/        removed {\n        }/\n/}" $MAEC
  fi

  # patch audio effects xml
  if echo $MAEX | grep -Eq xml; then
    #1sed -i "s/\"$LIBRMV\"/\"removed\"/g" $MAEX
    #1sed -i "s/\"$RMV\"/\"removed\"/g" $MAEX
    #1sed -i "s/\"$UUIDRMV\"/\"removed\"/g" $MAEX
    #2sed -i "s/\"$LIBRMV2\"/\"removed\"/g" $MAEX
    #2sed -i "s/\"$RMV2\"/\"removed\"/g" $MAEX
    #2sed -i "s/\"$UUIDRMV2\"/\"removed\"/g" $MAEX
    sed -i "/<libraries>/a\        <library name=\"$NAME\" path=\"$LIB\"\/>" $MAEX
    sed -i "/<effects>/a\        <effect name=\"$NAME\" library=\"$NAME\" uuid=\"$UUID\"\/>" $MAEX
    sed -i 's/<apply effect="ring_helper"\/>//g' $MAEX
    sed -i 's/<apply effect="alarm_helper"\/>//g' $MAEX
    sed -i 's/<apply effect="music_helper"\/>//g' $MAEX
    sed -i 's/<apply effect="voice_helper"\/>//g' $MAEX
    sed -i 's/<apply effect="notification_helper"\/>//g' $MAEX
    sed -i 's/<apply effect="music_post_proc"\/>//g' $MAEX
    sed -i 's/<apply effect="voice_post_proc"\/>//g' $MAEX
    sed -i 's/<apply effect="notification_post_proc"\/>//g' $MAEX
    sed -i 's/<apply effect="sa3d"\/>//g' $MAEX
    sed -i 's/<apply effect="fens"\/>//g' $MAEX
    sed -i 's/<apply effect="lmfv"\/>//g' $MAEX
    sed -i 's/<apply effect="removed"\/>//g' $MAEX
  fi

fi

# patch media codecs
FILE=media_codecs_vendor.xml
rm -f $MVETC/$FILE
AML=/data/adb/modules/aml/system/vendor/etc
ACDB=/data/adb/modules/acdb/system/vendor/etc
if [ -d $AML ]; then
  cp -f $VETC/$FILE $AML
elif [ -d $ACDB ]; then
  cp -f $VETC/$FILE $ACDB
else
  cp -f $VETC/$FILE $MVETC
  MODMC=$MVETC/$FILE
  if [ -f $MODMC ]; then
    sed -i '/<MediaCodecs>/a\
    <Include href="media_codecs_dolby_audio.xml"/>' $MODMC
  fi
fi

# directory
DIR=/data/vendor/dolby
if [ ! -d $DIR ]; then
  mkdir -p $DIR
fi
chmod 0770 $DIR
chown 1013.1013 $DIR
chcon u:object_r:vendor_data_file:s0 $DIR

# cleaning
if [ -f $MODDIR/cleaner.sh ]; then
  sh $MODDIR/cleaner.sh
  rm -f $MODDIR/cleaner.sh
fi



