ui_print " "

# information
MODVER=`grep_prop version $MODPATH/module.prop`
MODVERCODE=`grep_prop versionCode $MODPATH/module.prop`
ui_print "id=$MODID"
ui_print "version=$MODVER"
ui_print "versionCode=$MODVERCODE"
ui_print " "

# check bit
if [ "$IS64BIT" != true ]; then
  ui_print "- 32 bit"
  cp -rf $MODPATH/system32/* $MODPATH/system
  rm -rf `find $MODPATH/system -type d -name *64`
  rm -f $MODPATH/system.prop
  ui_print " "
else
  ui_print "- 64 bit"
  ui_print " "
fi

# check sdk
if [ "$API" -lt 28 ]; then
  ui_print "! Unsupported SDK $API. You have to upgrade your"
  ui_print "  Android version at least SDK API 28 to use this module."
  abort
else
  ui_print "- SDK $API"
  ui_print " "
fi

# cleaning
ui_print "- Cleaning..."
APP1=DaxUI
APP2=daxService
PKG1=com.dolby.daxappui
PKG2=com.dolby.service
PKGCACHE=/data/system/package_cache
rm -f `find /data/dalvik-cache -type f -name *$APP1*`
rm -f `find /data/dalvik-cache -type f -name *$APP2*`
rm -f `find $PKGCACHE -type f -name $APP1*`
rm -f `find $PKGCACHE -type f -name $APP2*`
rm -f `find $PKGCACHE -type f -name $PKG1*`
rm -f `find $PKGCACHE -type f -name $PKG2*`
rm -f /data/vendor/dolby/dap_sqlite3.db
rm -f $MODPATH/LICENSE
rm -rf $MODPATH/system32
conflict() {
  rm -rf /data/adb/modules_update/$MODULE
  rm -f /data/adb/modules/$MODULE/update
  touch /data/adb/modules/$MODULE/remove
  sh /data/adb/modules/$MODULE/uninstall.sh
  rm -f /data/adb/modules/$MODULE/uninstall.sh
  rm -rf /metadata/magisk/$MODULE
  rm -rf /mnt/vendor/persist/magisk/$MODULE
  rm -rf /persist/magisk/$MODULE
  rm -rf /data/unencrypted/magisk/$MODULE
  rm -rf /cache/magisk/$MODULE
}
MODULE=dolbyatmos
conflict
MODULE=DolbyAudio
conflict
MODULE=MotoDolby
conflict
ui_print " "

# store
cleanup() {
  rm -rf /data/user/*/$PKG1*
  rm -rf /data/user/*/$PKG2*
  sh $FOLDER/uninstall.sh
}

# check cleanup
FOLDER=/data/adb/modules/$MODID
FILE=$FOLDER/module.prop
if getprop | grep -Eq "dolby.force.cleanup\]: \[1"; then
  ui_print "- Cleaning-up Dolby data..."
  cleanup
  ui_print " "
elif [ -d $FOLDER ] && ! grep -Eq "$MODNAME" $FILE; then
  ui_print "- Different version detected"
  ui_print "  Cleaning-up Dolby data..."
  cleanup
  ui_print " "
fi

# store
clean_rules() {
  rm -f $MODPATH/sepolicy.rule
  rm -rf /metadata/magisk/$MODID
  rm -rf /mnt/vendor/persist/magisk/$MODID
  rm -rf /persist/magisk/$MODID
  rm -rf /data/unencrypted/magisk/$MODID
  rm -rf /cache/magisk/$MODID
}

backup() {
  if [ ! -f $FILE.orig ] && [ ! -f $FILE.bak ]; then
    cp -f $FILE $FILE.orig
  fi
}
patch_manifest() {
  backup
  ui_print "- Patching"
  ui_print "  $FILE"
  ui_print "  directly..."
  sed -i '/<manifest/a\
    <hal format="hidl">\
        <name>vendor.dolby.hardware.dms</name>\
        <transport>hwbinder</transport>\
        <version>1.0</version>\
        <interface>\
            <name>IDms</name>\
            <instance>default</instance>\
        </interface>\
        <fqname>@1.0::IDms/default</fqname>\
    </hal>' $FILE
  ui_print " "
}
patch_hwservice() {
  backup
  ui_print "- Patching"
  ui_print "  $FILE"
  ui_print "  directly..."
  sed -i '1i\
vendor.dolby.hardware.dms::IDms u:object_r:hal_dms_hwservice:s0' $FILE
  ui_print " "
}
check_patch() {
  if ! grep -Eq "$CHECK" $FILE; then
    ui_print "! Patching failed. Tap save button at the top right corner,"
    ui_print "  read the Magisk install process logs, and see"
    ui_print "  troubleshootings."
    abort
  fi
}

# check permissive
if getprop | grep -Eq "dolby.force.permissive\]: \[1"; then
  ui_print "- Using permissive method"
  clean_rules
  permissive
  ui_print " "
elif getprop | grep -Eq "dolby.force.permissive\]: \[2"; then
  ui_print "- Using both permissive and SE policy patch"
  permissive
  ui_print " "
fi

# magisk
if [ -d /sbin/.magisk ]; then
  MAGISKTMP=/sbin/.magisk
else
  MAGISKTMP=`find /dev -mindepth 2 -maxdepth 2 -type d -name .magisk`
fi

# remount
if [ "$BOOTMODE" == true ]; then
  if [ "$SYSTEM_ROOT" == true ]; then
    SYSTEM=$MAGISKTMP/mirror/system_root
  else
    SYSTEM=$MAGISKTMP/mirror/system
  fi
  VENDOR=$MAGISKTMP/mirror/vendor
else
  if [ "$SYSTEM_ROOT" == true ]; then
    SYSTEM=/system_root
  else
    SYSTEM=/system
  fi
  VENDOR=/vendor
fi
mount -o rw,remount $SYSTEM
mount -o rw,remount $VENDOR

# patch manifest.xml
if [ "$BOOTMODE" == true ]; then
  FILE="$MAGISKTMP/mirror/vendor/etc/vintf/manifest.xml
$MAGISKTMP/mirror/system_ext/etc/vintf/manifest.xml
$MAGISKTMP/mirror/system/etc/vintf/manifest.xml"
else
  FILE="/vendor/etc/vintf/manifest.xml
/system/system_ext/etc/vintf/manifest.xml
/system/etc/vintf/manifest.xml"
fi
CHECK=@1.0::IDms/default
if ! grep -Eq "$CHECK" $FILE; then
  if [ "$BOOTMODE" == true ]; then
    FILE=$MAGISKTMP/mirror/vendor/etc/vintf/manifest.xml
  else
    FILE=/vendor/etc/vintf/manifest.xml
  fi
  patch_manifest
fi
if ! grep -Eq "$CHECK" $FILE; then
  if [ "$BOOTMODE" == true ]; then
    FILE=$MAGISKTMP/mirror/system_ext/etc/vintf/manifest.xml
  else
    FILE=/system/system_ext/etc/vintf/manifest.xml
  fi
  patch_manifest
fi
if ! grep -Eq "$CHECK" $FILE; then
  if [ "$BOOTMODE" == true ]; then
    FILE=$MAGISKTMP/mirror/system/etc/vintf/manifest.xml
  else
    FILE=/system/etc/vintf/manifest.xml
  fi
  patch_manifest
fi
check_patch

# patch hwservice_contexts
if [ "$BOOTMODE" == true ]; then
  FILE="$MAGISKTMP/mirror/vendor/etc/selinux/vendor_hwservice_contexts
$MAGISKTMP/mirror/system_ext/etc/selinux/system_ext_hwservice_contexts
$MAGISKTMP/mirror/system/etc/selinux/plat_hwservice_contexts"
else
  FILE="/vendor/etc/selinux/vendor_hwservice_contexts
/system/system_ext/etc/selinux/system_ext_hwservice_contexts
/system/etc/selinux/plat_hwservice_contexts"
fi
CHECK=u:object_r:default_android_hwservice:s0
if ! grep -Eq "$CHECK" $FILE; then
  if [ "$BOOTMODE" == true ]; then
    FILE=$MAGISKTMP/mirror/vendor/etc/selinux/vendor_hwservice_contexts
  else
    FILE=/vendor/etc/selinux/vendor_hwservice_contexts
  fi
  CHECK=vendor.dolby.hardware.dms::IDms
  if ! grep -Eq "$CHECK" $FILE; then
    patch_hwservice
  fi
  if ! grep -Eq "$CHECK" $FILE; then
    if [ "$BOOTMODE" == true ]; then
      FILE=$MAGISKTMP/mirror/system_ext/etc/selinux/system_ext_hwservice_contexts
    else
      FILE=/system/system_ext/etc/selinux/system_ext_hwservice_contexts
    fi
    if ! grep -Eq "$CHECK" $FILE; then
      patch_hwservice
    fi
  fi
  if ! grep -Eq "$CHECK" $FILE; then
    if [ "$BOOTMODE" == true ]; then
      FILE=$MAGISKTMP/mirror/system/etc/selinux/plat_hwservice_contexts
    else
      FILE=/system/etc/selinux/plat_hwservice_contexts
    fi
    if ! grep -Eq "$CHECK" $FILE; then
      patch_hwservice
    fi
  fi
#  check_patch
fi

# remount
mount -o ro,remount $SYSTEM
mount -o ro,remount $VENDOR

# check dirac
if getprop | grep -Eq "dolby.force.disable.dirac\]: \[1"; then
  ui_print "- Activating dirac disabler..."
  sed -i  's/#1//g' $MODPATH/post-fs-data.sh
  sed -i  's/#1//g' $MODPATH/.aml.sh
  ui_print " "
fi

# check misoundfx
if getprop | grep -Eq "dolby.force.disable.misoundfx\]: \[1"; then
  ui_print "- Activating misoundfx disabler..."
  sed -i  's/#2//g' $MODPATH/post-fs-data.sh
  sed -i  's/#2//g' $MODPATH/.aml.sh
  ui_print " "
fi

# set permission
ui_print "- Setting permission, owner/group, and SE context..."
chmod 0755 $MODPATH/system/vendor/bin/hw/*
chown 0.2000 $MODPATH/system/vendor
chown -R 0.2000 $MODPATH/system/vendor/bin
chown 0.2000 $MODPATH/system/vendor/etc
chown 0.2000 $MODPATH/system/vendor/etc/dolby
chown 0.2000 $MODPATH/system/vendor/lib*
chown 0.2000 $MODPATH/system/vendor/lib*/soundfx
chcon -R u:object_r:vendor_file:s0 $MODPATH/system/vendor
chcon -R u:object_r:vendor_configs_file:s0 $MODPATH/system/vendor/etc
chcon u:object_r:hal_dms_default_exec:s0 $MODPATH/system/vendor/bin/hw/*
ui_print " "

# uninstaller
ZIP=/data/adb/modules/$MODID/DolbyModuleUninstaller.zip
ui_print "- Move $ZIP"
ui_print "  to sdcard and flash it via recovery if you got bootloop"
ui_print " "







