ui_print " "

# information
grep id= $MODPATH/module.prop
grep name= $MODPATH/module.prop
grep version= $MODPATH/module.prop
grep versionCode= $MODPATH/module.prop
grep author= $MODPATH/module.prop
ui_print " "

# magisk
if [ -d /sbin/.magisk ]; then
  MAGISKTMP=/sbin/.magisk
else
  MAGISKTMP=`find /dev -mindepth 2 -maxdepth 2 -type d -name .magisk`
fi

# remount
if [ "$BOOTMODE" == true ]; then
  if [ "$SYSTEM_ROOT" == true ]; then
    SYSTEM=$MAGISKTMP/mirror/system_root
  else
    SYSTEM=$MAGISKTMP/mirror/system
  fi
  VENDOR=$MAGISKTMP/mirror/vendor
else
  if [ "$SYSTEM_ROOT" == true ]; then
    SYSTEM=/system_root
  else
    SYSTEM=/system
  fi
  VENDOR=/vendor
fi
mount -o rw,remount $SYSTEM
mount -o rw,remount $VENDOR

# store
restore() {
  for FILES in $FILE; do
    mv -f $FILES.orig $FILES
    mv -f $FILES.bak $FILES
  done
}

# restore
ui_print "- Restoring original files... "
FILE=`find $SYSTEM $VENDOR -type f -name manifest.xml`
restore
FILE=`find $SYSTEM $VENDOR -type f -name *_hwservice_contexts`
restore
FILE=`find $SYSTEM $VENDOR -type f -name *_file_contexts`
restore
ui_print " "

# remount
mount -o ro,remount $SYSTEM
mount -o ro,remount $VENDOR

# remove modules
ui_print "- Removes Dolby modules... "
remove_modules() {
  rm -rf /data/adb/modules_update/$MODULE
  rm -f /data/adb/modules/$MODULE/update
  touch /data/adb/modules/$MODULE/remove
  rm -rf /metadata/magisk/$MODULE
  rm -rf /mnt/vendor/persist/magisk/$MODULE
  rm -rf /persist/magisk/$MODULE
  rm -rf /data/unencrypted/magisk/$MODULE
  rm -rf /cache/magisk/$MODULE
}
MODULE=dolbyatmos
remove_modules
MODULE=DolbyAudio
remove_modules
MODULE=MotoDolby
remove_modules
MODULE=DolbyAtmos
remove_modules
ui_print " "

# done
ui_print "- Done "
rm -rf /data/adb/modules*/$MODID
exit




