unzip -oj "${ZIPFILE}" 'module.prop' 'service.sh' 'boot-completed.sh' 'fix.sh' -d "${MODPATH}/" 1>&2

ui_print ''
ui_print ' - 以下为设备兼容情况'
ui_print ''

test -f '/sys/class/mi_display/disp-DSI-0/dc_status' && \
  ui_print ' - [✔] 小米 DC模式文件1: 存在' || \
    ui_print ' - [✗] 小米 DC模式文件1: 不存在'
test -f '/sys/class/mi_display/disp-DSI-0/disp_param' && \
  ui_print ' - [✔] 小米 DC模式文件2: 存在' || \
    ui_print ' - [✗] 小米 DC模式文件2: 不存在'
test "$(settings get secure 'display_dc_settings_switch')" != 'null' && \
  ui_print ' - [✔] OPPO DC模式开关: 存在' || \
    ui_print ' - [✗] OPPO DC模式开关: 不存在'
test -f '/sys/kernel/oplus_display/dimlayer_hbm' && \
  ui_print ' - [✔] OPPO DC模式文件1: 存在' || \
    ui_print ' - [✗] OPPO DC模式文件1: 不存在'
test -f '/sys/kernel/oplus_display/dimlayer_bl_en' && \
  ui_print ' - [✔] OPPO DC模式文件2: 存在' || \
    ui_print ' - [✗] OPPO DC模式文件2: 不存在'
test "$(settings get system 'gt_mode_state_setting')" != 'null' && \
  ui_print ' - [✔] 真我GT模式开关: 存在' || \
    ui_print ' - [✗] 真我GT模式开关: 不存在'
test -f '/proc/touchpanel/game_switch_enable' && \
  ui_print ' - [✔] 游戏模式(采样率)文件: 存在' || \
    ui_print ' - [✗] 游戏模式(采样率)文件: 不存在'

ui_print ''
ui_print ' - 不支持的不会修改成功，但是不会影响模块运行(包括硬件不支持)'
ui_print ''

for pid in $(pidof sh) ; do
  [[ "$(cat "/proc/${pid}/cmdline" 2>/dev/null)" == '*/manyapps_dcgttouch/*' ]] && \
    kill -15 "${pid}"
done
for pid in $(pidof busybox) ; do
  [[ "$(cat "/proc/${pid}/cmdline" 2>/dev/null)" == '*/manyapps_dcgttouch/*' ]] && \
    kill -15 "${pid}"
done
for pid in $(pidof ash) ; do
  [[ "$(cat "/proc/${pid}/cmdline" 2>/dev/null)" == '*/manyapps_dcgttouch/*' ]] && \
    kill -15 "${pid}"
done

sh "${MODPATH}/boot-completed.sh"

ui_print ' - 模块已经运行'
ui_print ''

SKIPUNZIP=1