##########################################################################################
# Magisk Module Template Config Script
# by 是陉湮吖
##########################################################################################
##########################################################################################
# Instructions:
# 1. Place your files into system folder (delete the placeholder file)
# 2. Fill in your module's info into module.prop
# 3. Configure the settings in this file (config.sh)
# 4. If you need boot scripts, add them into common/post-fs-data.sh or common/service.sh
# 5. Add your additional or modified system properties into common/system.prop
##########################################################################################
# Configs
##########################################################################################
# Set to true if you need to enable Magic Mount
# Most mods would like it to be enabled
SKIPMOUNT=false
# Set to true if you need to load system.prop
PROPFILE=true
# Set to true if you need post-fs-data script
POSTFSDATA=false
# Set to true if you need late_start service script
LATESTARTSERVICE=true
##########################################################################################
# Installation Message
##########################################################################################
# Set what you want to show when installing your mod
##########################################################################################
# Replace list
##########################################################################################
# List all directories you want to directly replace in the system
# Check the documentations for more info about how Magic Mount works, and why you need this
# This is an example
REPLACE="
"
# Construct your own list here, it will override the example above
# !DO NOT! remove this if you don't need to replace anything, leave it empty as it is now
REPLACE="
"
#添加您要精简的APP/文件夹目录
##########################################################################################
# Permissions
##########################################################################################
#释放文件，普通shell命令
on_install() {
  ui_print "- 正在释放文件"
  unzip -o "$ZIPFILE" 'system/*' -d $MODPATH >&2
}
set_permissions() {
  # Only some special files require specific permissions
  # The default permissions should be good enough for most cases
  # Here are some examples for the set_perm functions:
  # set_perm_recursive  <dirname>                <owner> <group> <dirpermission> <filepermission> <contexts> (default: u:object_r:system_file:s0)
  # set_perm_recursive  $MODPATH/system/lib       0       0       0755            0644
  # set_perm  <filename>                         <owner> <group> <permission> <contexts> (default: u:object_r:system_file:s0)
  # set_perm  $MODPATH/system/bin/app_process32   0       2000    0755         u:object_r:zygote_exec:s0
  # set_perm  $MODPATH/system/bin/dex2oat         0       2000    0755         u:object_r:dex2oat_exec:s0
  # set_perm  $MODPATH/system/lib/libart.so       0       0       0644
  # The following is default permissions, DO NOT remove
  set_perm_recursive  $MODPATH  0  0  0755  0644
  #设置权限，基本不要去动
}