#!/system/bin/sh
function correctpath(){
	case `echo "$1"` in
	/system_ext* | /vendor* | /product* )
		echo "/system"$1""
	;;
	/system* )
		echo "$1"
	;;
	esac
}

number1="<maxNum name=.* />"
number2='<maxNum name="2000" />'



echo ""
echo "∞————————————————————————∞"
echo -e "\n－ 查找文件中……\n"
originalfile=`find /system /vendor /product /system_ext -iname "sys_multi_app_config.xml" 2> /dev/null | head -n 1`
sysfile=$(correctpath $originalfile)
test "$sysfile" != "" && {
	echo "－ 找到文件 $sysfile"
	mkdir -p $MODPATH${sysfile%/*}
	cp -rf $sysfile $MODPATH${sysfile%/*}
	file=$MODPATH$sysfile
	sed -i "s|$number1|$number2|g" $file
	test $? == 0 && echo -e "\n－ 修改多开应用至2000成功✔！\n" || echo -e "\n－ 修改多开应用至2000失败❌！\n"
	echo "－ 添加包名中……"
	all=$(pm list package -3 | wc -l)
	for i in $(pm list package -3 | cut -d: -f2) ;do
		sed -i "/<\/allowed.*>/i\         <item name=\"$i\" \/>" $file
	done
	echo "－ 完成！共计添加包名"$all"个！"
} || abort "－ 不存在文件sys_multi_app_config.xml！"
echo ""
echo "∞————————————————————————∞"
