##########################################################################################
#
# Magisk Module Template Config Script
# by 小白杨
#
##########################################################################################
##########################################################################################
#
# Instructions:
#
# 1. Place your files into system folder (delete the placeholder file)
# 2. Fill in your module's info into module.prop
# 3. Configure the settings in this file (config.sh)
# 4. If you need boot scripts, add them into common/post-fs-data.sh or common/service.sh
# 5. Add your additional or modified system properties into common/system.prop
#
##########################################################################################

##########################################################################################
# Configs
##########################################################################################

# Set to true if you need to enable Magic Mount
# Most mods would like it to be enabled
SKIPMOUNT=false
#是否安装模块后自动关闭，改为true，安装后不会自动勾选启用
LATESTARTSERVICE=false
POSTFSDATA=false
PROPFILE=false
##########################################################################################
# Installation Message
##########################################################################################

# Set what you want to show when installing your mod

print_modname() {
  ui_print "*******************************"
  ui_print "     	Magisk Module        "
  ui_print "    For    By 小白杨"
  ui_print "*******************************"
}

##########################################################################################
# Replace list
##########################################################################################

# List all directories you want to directly replace in the system
# Check the documentations for more info about how Magic Mount works, and why you need this

# This is an example
REPLACE="
/system/app/Youtube
/system/priv-app/SystemUI
/system/priv-app/Settings
/system/framework
"

# Construct your own list here, it will override the example above
# !DO NOT! remove this if you don't need to replace anything, leave it empty as it is now
REPLACE="

"
#添加您要精简的APP/文件夹目录
#例如：精简状态栏，找到状态栏目录为  /system/priv-app/SystemUI/SystemUI.apk
#转化加入:/system/priv-app/SystemUI
#（可以搭配高级设置获取APP目录）

##########################################################################################
# Permissions
##########################################################################################
#释放文件，普通shell命令
# MAGISK_VER (string): the version string of current installed Magisk
# MAGISK_VER_CODE (int): the version code of current installed Magisk
# BOOTMODE (bool): true if the module is currently installing in Magisk Manager
# MODPATH (path): the path where your module files should be installed
# TMPDIR (path): a place where you can temporarily store files
# ZIPFILE (path): your module's installation zip
# ARCH (string): the architecture of the device. Value is either arm, arm64, x86, or x64
# IS64BIT (bool): true if $ARCH is either arm64 or x64
# API (int): the API level (Android version) of the device
#

on_install() {
  ui_print "- 正在释放文件"
  unzip -o "$ZIPFILE" 'system/*' -d $MODPATH >&2

  require_api
  require_check_app

}

set_permissions() {
  # Only some special files require specific permissions
  # The default permissions should be good enough for most cases

  # Here are some examples for the set_perm functions:

  # set_perm_recursive  <dirname>                <owner> <group> <dirpermission> <filepermission> <contexts> (default: u:object_r:system_file:s0)
  # set_perm_recursive  $MODPATH/system/lib       0       0       0755            0644

  # set_perm  <filename>                         <owner> <group> <permission> <contexts> (default: u:object_r:system_file:s0)
  # set_perm  $MODPATH/system/bin/app_process32   0       2000    0755         u:object_r:zygote_exec:s0
  # set_perm  $MODPATH/system/bin/dex2oat         0       2000    0755         u:object_r:dex2oat_exec:s0
  # set_perm  $MODPATH/system/lib/libart.so       0       0       0644

  # The following is default permissions, DO NOT remove
  set_perm_recursive $MODPATH 0 0 0755 0644

  #设置权限，基本不要去动
}

##########################################################################################
# Custom Functions
##########################################################################################

# This file (config.sh) will be sourced by the main flash script after util_functions.sh
# If you need custom logic, please add them here as functions, and call these functions in
# update-binary. Refrain from adding code directly into update-binary, as it will make it
# difficult for you to migrate your modules to newer template versions.
# Make update-binary as clean as possible, try to only do function calls in it.

require_check_app() {
  ui_print "*******************************"

  tmppackage=$(dumpsys package com.byyoung.setting | grep version)
  if [ "$tmppackage" = "" ]; then
    ui_print "您还没有安装了爱玩机工具箱，正在跳转链接下载"
    am start -a android.intent.action.VIEW -d https://www.coolapk.com/apk/com.byyoung.setting
  else
    ui_print "您已经安装了爱玩机工具箱，尽情享受吧"
  fi
  ui_print "*******************************"
  ui_print "刷入模块完成，欢迎使用V19.0"

}
require_api() {
  ui_print "*******************************"

  API=$(getprop ro.build.version.sdk)
  MIUIVERSION=$(getprop ro.miui.ui.version.name)
  ApkPath=$MODPATH/system/priv-app/MiuiPackageInstaller

  if [ "$MIUIVERSION" = "" ]; then
    ui_print "您的设备不是MIUI,安装终止"
    exit

  elif [[ -d /system/product ]]; then
    ui_print "- MIUI版本: $MIUIVERSION"
    ui_print "- 正在以SDK29方式安装:"
    mkdir -p $MODPATH/system/product/priv-app/MiuiPackageInstaller
    mv $ApkPath $MODPATH/system/product/priv-app
    rm -r $MODPATH/system/priv-app
    ui_print "- 清理缓存完毕"

  else

    ui_print "- MIUI版本: $MIUIVERSION"
    ui_print "- 正在以兼容方式安装:"

  fi

}
