##########################################################################################
#
# Magisk Module Template Config Script
# by topjohnwu
#
##########################################################################################
##########################################################################################
#
# Instructions:
#
# 1. Place your files into system folder (delete the placeholder file)
# 2. Fill in your module's info into module.prop
# 3. Configure the settings in this file (config.sh)
# 4. If you need boot scripts, add them into common/post-fs-data.sh or common/service.sh
# 5. Add your additional or modified system properties into common/system.prop
#
##########################################################################################

##########################################################################################
# Configs
##########################################################################################

# 如果你需要magic mount,请设置成true
AUTOMOUNT=true

# 如果你需要重写system.prop,请设置成true
PROPFILE=false

# 如果你需要post-fs-data脚本,请设置成true
POSTFSDATA=false

# 如果你需要service脚本,请设置成true
LATESTARTSERVICE=true

##########################################################################################
# Installation Message
##########################################################################################

# 这是你安装模块时显示的信息

print_modname() {
  ui_print "*******************************"
  ui_print "   MIUI11主题破解模块    "
  ui_print "理论上支持安卓8.0+的所有MIUI11"
  ui_print "       By:消失的烁星空       "
  ui_print "*******************************"
}

##########################################################################################
# Replace list
##########################################################################################

# 这个列表包含了需要直接替换的文件
# 当确认magic mount不能正常工作时才需要使用这个


# 将你需要替换的文件放到下面的列表中
# 如果你不需要替换文件,请保持这个状态,千万不要删除这行
REPLACE="
/system/app/ThemeManager
"

##########################################################################################
# Permissions
##########################################################################################

set_permissions() {
  # 只有部分特殊文件需要设置权限
  # 默认的权限适用于大多数情况

  # 这是部分 set_perm 和 set_perm_recursive 函数的示例

  # set_perm_recursive  <dirname>                <owner> <group> <dirpermission> <filepermission> <contexts> (default: u:object_r:system_file:s0)
  # set_perm_recursive  $MODPATH/system/lib       0       0       0755            0644

  # set_perm  <filename>                         <owner> <group> <permission> <contexts> (default: u:object_r:system_file:s0)
  # set_perm  $MODPATH/system/bin/app_process32   0       2000    0755         u:object_r:zygote_exec:s0
  # set_perm  $MODPATH/system/bin/dex2oat         0       2000    0755         u:object_r:dex2oat_exec:s0
  # set_perm  $MODPATH/system/lib/libart.so       0       0       0644
  # 不要删除这一行!
  set_perm_recursive  $MODPATH  0  0  0755  0644
}

