# Magisk 模块脚本配置
# 说明：
# 1. 将你要替换的文件放入 system 文件夹 (删除 placeholder 文件)
# 2. 将模块信息写入 module.prop
# 3. 在这个文件中进行设置 (customize.sh)
# 4. 如果你需要在启动时执行命令, 请把它们加入 post-fs-data.sh 或 service.sh
# 5. 如果需要修改系统属性(build.prop), 请把它加入 system.prop

# 如果你需要启用 Magic Mount 请把它设置为 true 不启用则设置为 false
# 大多数模块都需要启用它
AUTOMOUNT=true

SKIPMOUNT=false
#是否安装模块后自动关闭，改为false，安装后不会自动勾选启用

# Set to true if you need to load system.prop
PROPFILE=false
#是否使用system.prop文件

# Set to true if you need post-fs-data script
POSTFSDATA=false
#是否使用post-fs-data脚本执行文件

# Set to true if you need late_start service script
LATESTARTSERVICE=true
#是否在开机时候允许加载service.sh中脚本


# 列出你想在系统中直接删除的所有路径 一行一个路径 只能文件夹 不能文件 并且只能system里面的文件夹
# 此命令会删除下列路径文件夹内的所有文件
# /system/SuiNian666/ 只是一个例子 如果你要删除其他路径 请删除那一行例子
REPLACE="
"

# 这个文件 (customize.sh) 将被安装脚本在 util_functions.sh 之后 source 化（设置为环境变量）
# 如果你需要自定义操作, 请在这里以函数方式定义它们 然后在 update-binary 里调用这些函数
# 不要直接向 update-binary 添加代码 因为这会让你很难将模块迁移到新的模板版本
# 尽量不要对 update-binary 文件做其他修改 尽量只在其中执行函数调用
## 执行模块安装
#安装模块时打印的信息，不需要的部分可以自己删除，也可以自己添加。
print_modname() {
ui_print "
 ****************************
 - 模块: $MODNAME
 - 模块ID: $MODID
 - 作者: 某安男神
 ****************************
 "
}

#开始安装（shell命令）
on_install() {
    mkdir -p $MODPATH/system/product/etc/device_features/
    cp -rf /product/etc/device_features/* $MODPATH/system/product/etc/device_features/
    dir=$MODPATH/system/product/etc/device_features/*
filelist=`ls $dir`
for FIND_FILE in $filelist
do
	sed -i 's/support_dc_backlight\">false/support_dc_backlight\">true/g' $FIND_FILE
sed -i 's/support_secret_dc_backlight\">true/support_secret_dc_backlight\">false/g' $FIND_FILE
FIND_STR="<item>90<"
# 判断匹配函数，匹配函数不为0，则包含给定字符
if [ `grep -c "$FIND_STR" $FIND_FILE` -eq '0' ];then
    sed -i 's/<item>60/<item>90<\/item>\n<item>60/g' $FIND_FILE
fi
done
}

#设置权限
set_permissions() {
set_perm_recursive  $MODPATH  0  0  0755  0644
}