#!/system/bin/sh
sdcard_rw() {
	file="/data/media/0/sdcard_rw_test.asg"
	if [[ -f "${file}" ]]; then
		rm "${file}"
		while [[ -f "${file}" ]]
		do
			sleep 3
			rm "${file}"
		done
	else
		touch "${file}"
		until [[ -f "${file}" ]]
		do
			sleep 3
			touch "${file}"
		done
		rm "${file}"
	fi
	unset file
}
sdcard_rw
DIR="${0%/*}"
[[ -d "${DIR}/Script" ]] || mkdir "${DIR}/Script"
cat <<EOF > "${DIR}/Script/ASGuard_Function.sh"
version="v5.0"
versionCode="202201061"
inform="ASGuard \${version}(\${versionCode}) created by 沍澤"
CONFIG="/data/media/0/Android/ASGuard.conf"
LOG_PATH="/data/media/0/Android/log_ASG.txt"
EAS_PATH="${DIR}/config/EAS.ini"
PROP="${DIR}/module.prop"
#取不同格式时间 1: 时间戳 其它: hh:mm:ss
get_time() {
	case "\${1:-0}" in
	1) date '+%s' ;;
	*) date '+%H:%M:%S' ;;
	esac
}
#计算时差 参数: 之前的时间
time_duration() {
	echo \$(( \${2:-\$(get_time 1)} - \${1:-\$(get_time 1)} )) | awk '{t=split("60 s 60 m 24 h 999 d",a);for(n=1;n<t;n+=2){if(\$1==0)break;s=\$1%a[n]a[n+1]s;\$1=int(\$1/a[n])}print s}'
}
#更改prop描述 参数：修改内容
change_prop() {
	cat <<PROP > "\${PROP}"
id=huzeASGuard
name=H-无障碍服务守护[ASGuard]
version=\${version}
versionCode=\${versionCode}
author=沍澤
description=开机自动开启且实时保护无障碍服务,防止应用意外关闭导致无障碍服务连同关闭.\${1:+[}\${1:-}\${1:+]}
PROP
}
#加载配置，参数：无
load_config() {
	if [[ ! -f "\${CONFIG}" ]]; then
		change_prop "用户配置丢失停止运行"
		exit
	fi
	source "\${CONFIG}"
	CTime=\$(echo \${CTime:=3} | tr -cd "[0-9]")
	[[ \$(echo \${CTime:=3}) -lt 1 ]] && CTime=3
	if [[ -n "\$(echo \${AS} | sed 's/ //g')" ]]; then
		AS=\$(echo \${AS} | sed 's/ /\\n/g' | sort | uniq)
		running=1
		return 0
	else
		running=0
		return 1
	fi
}
#读取无障碍功能开关，输出换行变量
read_EAST() {
	local p1 p2 var tmp
	tmp=""
	for var in \$(settings get secure enabled_accessibility_services | sed 's/:/ /g')
	do
		p1="\${var%/*}"
		p2="\${var#*/}"
		[[ "\${p2:0:1}" = '.' ]] && tmp="\${tmp}\${p1}/\${p1}\${p2}\\n" || tmp="\${tmp}\${var}\\n"
	done
	EAST=\$(echo -e "\${tmp}" | sort | uniq | sed '/^\$/d')
	unset p1 p2 var tmp
}
#写入无障碍功能开关，参数：写入的名称 原始的名称
write_EAST() {
	[[ -z "\${1:-}" ]] && return
	tmp_EAST=\$(echo \${1:-})
	tmp_EAST=\${tmp_EAST// /:}
	[[ -n "\$(echo \${2:-} | sed 's/ //g')" ]] && original_EAST="\$(echo \${2:-} | sed 's/ /:/g')"
	settings put secure enabled_accessibility_services "\${original_EAST:-}\${original_EAST:+:}\${tmp_EAST}"
	if [[ \${rewrite:=0} = 1 ]]; then
		settings put secure enabled_accessibility_services "\${original_EAST:-}"
		sleep 0.1
		settings put secure enabled_accessibility_services "\${original_EAST:-}\${original_EAST:+:}\${tmp_EAST}"
	fi
	unset tmp_EAST original_EAST
}
#写入EAS.ini (默认:追加)
#参数：写入EAS的文本 写入模式0/1(覆盖/追加)
write_EAS() {
	case "\${2:-1}" in
	0) EAS=\$(echo "\${1:-}" | sort | uniq | sed '/^\$/d')
	echo -e "\${EAS}" > "\${EAS_PATH}"
	mylog "EAS文件写入模式: 覆盖\\n内容: \${1:-}" ;;
	*) EAS=\$(echo -e "\${1:-}\\n\${EAS}" | sort | uniq | sed '/^\$/d')
	echo "\${EAS}" > "\${EAS_PATH}"
	mylog "EAS文件写入模式: 追加\\n内容: \${1:-}" ;;
	esac
}
#参数 EAS
check_EAS() {
	#检查和去除EAS.ini重复的名称并重新写入#
	touch "\${EAS_PATH}"
	EAS=\$(cat "\${EAS_PATH}")
	if [[ -n "\$(echo \${EAS} | sed 's/ //g')" ]]; then
		EAS=\$(echo "\${EAS}" | sed '/^\$/d' | sort | uniq)
		for var in \$(echo \${EAS})
		do
			p1="\${var%/*}"
			p2="\${var#*/}"
			[[ "\${p2:0:1}" = '.' ]] && tmpEAS="\${tmpEAS}\${p1}/\${p1}\${p2}\\n" || tmpEAS="\${tmpEAS}\${var}\\n"
		done
		EAS=\$(echo -e "\${tmpEAS}")
		write_EAS "\${EAS}" 0
		unset p1 p2 var tmpEAS
		return 0
	else
		mylog "检查EAS文件内容为空" "ASGuard"
		return 1
	fi
}
#获取包含AS或参数的EAS项(格式统一)，一般用于写入EAST
#参数：AS 
get_EAS() {
	[[ -z "\${EAS}" ]] && return 1
	#分隔文本
	local p1 p2 tmp var result
	[[ -z "\$(echo \${1:-} | sed 's/ //g')" ]] && p1="\${AS}" || p1="\$1"
	#检查开关是否存在配置包名，存在则放在后面写入
	for var in \$(echo \${EAS})
	do
		p2="\${var%/*}"
		#从EAS.ini中取用户配置项的开关
		result=\$(echo "\${p1}" | grep "\${p2}")
		[[ -n "\${result}" ]] && tmp="\${tmp}\${var}\\n"
	done
	echo -e "\${tmp}"
	unset p1 p2 tmp var result
}
#获取EAST里面包含参数的项(格式不统一)，一般用于写入EAS
#参数：AS EAST
get_EAST() {
	local list var tmp result p1
	[[ -z "\$(echo \${1:-} | sed 's/ //g')" ]] && list="\${AS}" || list="\${1:-}"
	[[ -z "\$(echo \${2:-} | sed 's/ //g')" ]] && var="\${EAST}" || var="\$2"
	for var in \$(echo \${var})
	do
		p1="\${var%/*}"
		result=\$(echo "\${list}" | grep "\${p1}" | wc -l)
		if [[ \${result} -ne 0 ]]; then
			result=\$(echo "\${tmp}" | grep "\${var}" | wc -l)
			[[ \${result} -eq 0 ]] && tmp="\${tmp}\${var}\\n"
		fi
	done
	echo -e "\${tmp}"
	unset list var tmp result p1
}
#取相同项
take_same() {
	local max min
	max=\$(echo "\${1:-}" | sort | uniq)
	min=\$(echo "\${2:-}" | sort | uniq)
	echo -e "\${max}\${max:+\\n}\${lin}" | sort | uniq -d
	unset max min
}
#取差值
get_difference() {
	echo -e "\${1:-}\${1:+\\n}\${2:-}" | sort | uniq -u
}
#判断两个参数的差异
#参数：新AS 旧AS
if_AS() {
	if [[ "\$(echo \${1:-})" != "\$(echo \${2:-})" ]]; then		#用户配置是否发生改变
		local tmp_AS
		tmp_AS=\$(take_same "\${1:-}" "\${2:-}")
		tmp_AS=\$(get_difference "\${1:-}" "\${tmp_AS}")		#只管增加的AS，减少的AS不处理
		if [[ -z "\$(echo \${tmp_AS} | sed 's/ //g')" ]]; then		#判断有无增加的配置
			mylog "应用列表减少" "ASGuard.conf"
			unset tmp_AS
			return
		else
			mylog "应用列表增加" "ASGuard.conf"
		fi
		#取开关名称
		local tmp_EAStmp_EAST plus
		tmp_EAS=\$(get_EAST "\${tmp_AS}")
		tmp_EAST=\$(get_EAS "\${tmp_AS}")
		plus=0
		add_whitelist "\${tmp_AS}" &
		[[ -n "\$(echo \${tmp_EAS})" ]] && plus=\$(( plus + 1 ))
		[[ -n "\$(echo \${tmp_EAST})" ]] && plus=\$(( plus + 2 ))
		case "\${plus}" in		#根据以上开关出现空文本情况标记，0:全空 1:从EAS取空 2:从EAST取空 3:全不为空
		0) mylog "\\"EAS.ini\\" 与 \\"EAST\\" 为空" "ASGuard"
		return 1 ;;
		1) write_EAS "\${tmp_EAS}" 1
		mylog " [ASGuard]: 标记 \\"\$(echo \${tmp_EAS})\\"" ;;
		2) read_EAST
		write_EAST "\${tmp_EAST}" "\${EAST}"
		mylog " [ASGuard]: 开启 \\"\$(echo \${tmp_EAST})\\"" ;;
		3) local result result1 result2
		result=\$(take_same "\${tmp_EAST}" "\${tmp_EAS}")
		result1=\$(get_difference "\${tmp_EAST}" "\${result}")
		result2=\$(get_difference "\${tmp_EAS}" "\${result}")
		if [[ -n "\${result1}" ]]; then
			read_EAST
			write_EAST "\${result1}" "\${EAST}"
			mylog "开启 \\"\$(echo \${result1})\\"" "ASGuard"
		fi
		if [[ -n "\${result2}" ]]; then
			write_EAS "\${result2}" 1
			mylog "标记 \\"\$(echo \${result2})\\"" "ASGuard"
		fi ;;
		esac
	fi
}
if_EAST() {
	if [[ "\${1:-}" != "\${2:-}" ]];then
		local result iEAST dEAST
		result=\$(take_same "\${1:-}" "\${2:-}")
		iEAST=\$(get_difference "\${1:-}" "\${result}")
		dEAST=\$(get_difference "\${2:-}" "\${result}")
		[[ -n "\$(echo \${dEAST})" ]] && DEAST "\${dEAST}" &
		[[ -n "\$(echo \${iEAST})" ]] && IEAST "\${iEAST}"
		wait
		unset result iEAST dEAST
	fi
}
IEAST() {
	local tmpEAS
	tmpEAS=\$(get_EAST "\${AS}" "\${1:-}")
	#不为空则写入
	if [[ -n "\${tmpEAS}" ]]; then
		local result
		result=\$(take_same "\${tmpEAS}" "\${EAS}")
		tmpEAS=\$(get_difference "\${tmpEAS}" "\${result}")
		[[ -n "\$(echo \${tmpEAS})" ]] && write_EAS "\${tmpEAS}" 1
		unset result
	fi
	unset tmpEAS
}
DEAST() {
	local tmpEAST
	tmpEAST=\$(get_EAST "\${AS}" "\${1:-}")
	if [[ -n "\$(echo \${tmpEAST})" ]]; then
		#防止其它线程处理的数据无效，因此写入前再读一次
		read_EAST
		write_EAST "\${tmpEAST}" "\${EAST}"
		mylog "\\"\$(echo \${tmpEAST})\\"被关闭，正在开启" "ASGuard"
	fi
	unset tmpEAST
}
#加入电池优化白名单，参数：白名单包名
add_whitelist() {
	mylog "开始添加配置的APP至电池优化白名单..." "Whitelist"
	if [[ -n "\$(echo \${1:-} | sed 's/ //g')" ]]; then
		local var
		for var in \$(echo \$1)
		do
			dumpsys deviceidle whitelist "+\${var}"
		done
		mylog "已加入电池优化白名单包名 <= \$(echo \$1)" "Whitelist"
	else
		mylog "列表为空" "Whitelist"
	fi
}
WHITELIST() {
	start_whitelist_clear "\${1:-}" &
}
EOF
#优化白名单
if [[ ${whitelistclear:=1} -eq 1 ]]; then
	cat <<EOF >> "${DIR}/Script/ASGuard_Function.sh"

start_whitelist_clear() {
	clean_whitelist
	add_whitelist "\${1:-}"
}
#清空电池优化白名单，参数：
clean_whitelist() {
	mylog "90秒后清除系统预设电池优化白名单，并将配置应用白名单加入电池优化白名单" "Whitelist"
	sleep 90
	mylog "开始清除系统预设电池优化白名单..." "Whitelist"
	local app
	local line
	app="\$(pm list packages --user 0 | sed 's/package://g')"
	for line in \$(echo \${app})
	do
		dumpsys deviceidle whitelist "-\${line}" >/dev/null 2>&1
	done
	mylog "清除完成" "Whitelist"
}
EOF
else
	cat <<EOF >> "${DIR}/Script/ASGuard_Function.sh"
clean_whitelist() {
	return
}

start_whitelist_clear() {
	return
}
EOF
fi
#时间记录
if [[ ${timemarker:=1} -eq 1 ]]; then
	cat <<EOF >> "${DIR}/Script/ASGuard_Function.sh"
#更新显示运行时间，参数：无
mark_time() {
	local timer_end duration
	duration="\$(echo \$(( \$(get_time 1) - \${timer_start} )) | awk '{t=split("60 s 60 m 24 h 999 d",a);for(n=1;n<t;n+=2){if(\$1==0)break;s=\$1%a[n]a[n+1]s;\$1=int(\$1/a[n])}print s}')"
	change_prop "本次截至\$(get_time)已运行:\${duration}"
	unset duration
}
EOF
else
	cat <<EOF >> "${DIR}/Script/ASGuard_Function.sh"
mark_time() {
	return
}
EOF
fi
#log输出
if [[ ${log:=1} = 1 ]]; then
	cat <<EOF >> "${DIR}/Script/ASGuard_Function.sh"
#输出日志自带时间，参数：日志内容 发送分支
mylog() {
	echo -e "[\$(get_time)]\${2:+ [}\${2:-}\${2:+]}: "\$1 >> "\${LOG_PATH}"
}
EOF
else
	cat <<EOF >> "${DIR}/Script/ASGuard_Function.sh"
mylog() {
	return
}
EOF
fi
#定时刷新
if [[ ${ReloadTime:=0} -gt 1 ]]; then
	cat <<EOF >> "${DIR}/Script/ASGuard_Function.sh"
RELOAD() {
	ps -ef | grep "ASGuard_Reload.sh" | grep -v grep | awk '{print \$2}' | xargs kill -9 > /dev/null 2>&1
	cat <<EOF2 > "\${DIR}/Script/ASGuard_Reload.sh"
#!${DIR}/busybox/bin/sh
source "\\\${DIR}/Script/ASGuard_Function.sh"
rm -rf "\\\${DIR}/Script/ASGuard_Reload.sh"
while [[ "\\\$(ps -ef | grep "ASGuard_Process.sh" | grep -v grep | wc -l)" != "0" ]]
do
	sleep "\\\${ReloadTime}m"
	read_EAST
	write_EAST "\\\${EAST}"
	mylog "刷新无障碍功能开关完成，下一次执行时间: \${ReloadTime}分钟后" "Reload"
done
exit
EOF2
	chmod 777 "\${DIR}/Script/ASGuard_Reload.sh"
	chown 'root:root' "\${DIR}/Script/ASGuard_Reload.sh"
	busybox sh "\${DIR}/Script/ASGuard_Reload.sh" &
	exit
}
EOF
else
	cat <<EOF >> "${DIR}/Script/ASGuard_Function.sh"
RELOAD() {
	return
}
EOF
fi
cat <<EOF > "${DIR}/Script/ASGuard_Process.sh"
#!${DIR}/busybox/bin/sh
#加载函数
Running_time="\$(date '+%s')"
export AS EAS EAST reload
DIR="\${0%/*}"
DIR="\${DIR//\/Script/}"
reload=\${reload:=0}
#inform CONFIG LOG_PATH EAS_PATH PROP
source "\${DIR}/Script/ASGuard_Function.sh"
change_prop '正在运行'
if [[ \${log:=1} != 0 ]]; then
	echo "\${inform}" > "\${LOG_PATH}"
	echo "运行日期:\$(date '+%Y.%m.%d %H:%M:%S')" >> "\${LOG_PATH}"
else
	[[ -f "\${LOG_PATH}" ]] && rm -rf "\${LOG_PATH}" >/dev/null 2>&1
fi
#读取配置变量: AS package_whitelist CTime whitelistclear timemarker rewrite log MODPATH
load_config
#初始化
if [[ \${reload} = 1 ]]; then
	mylog "重载AS: \$(echo \${AS})"
else
	WHITELIST "\${AS}\\n\${package_whitelist}" &
	mylog "加载AS: \$(echo \${AS})"
fi
#启用无障碍设置
settings put secure accessibility_enabled 1
mylog "检查EAS.ini文件..."
check_EAS
if [[ \${?:-0} = 0 ]]; then
	tmpEAST="\$(get_EAS)"
	if [[ \${cover:=0} -ne 1 ]]; then
		result=\$(take_same "\${tmpEAST}" "\${EAST}")
		tmpEAST=\$(get_difference "\${tmpEAST}" "\${result}")
		unset result
	fi
	if [[ -n "\$(echo \${tmpEAST})" ]]; then
		mylog "正在打开APP无障碍服务..."
		if [[ \${cover} = 1 ]]; then
			write_EAST "\${tmpEAST}"
		else
			read_EAST
			write_EAST "\${tmpEAST}" "\${EAST}"
		fi
		mylog "开启无障碍服务完成"
	else
		mylog "没有可开启的无障碍功能开关"
	fi
	unset tmpEAST
fi
#初始化大致完成
duration="\$(echo \$(( \$(get_time 1) - \${Running_time} )) | awk '{t=split("60 s 60 m 24 h 999 d",a);for(n=1;n<t;n+=2){if(\$1==0)break;s=\$1%a[n]a[n+1]s;\$1=int(\$1/a[n])}print s}')"
[[ -z "\${duration}" ]] && duration="0s"
mylog "初始化完成。耗时\${duration}"
unset Running_time duration
#初始化完成
if [[ \${stop:-0} = 1 ]]; then
	mylog "服务已完成，进程结束" "ASGuard"
	exit 0
fi
load_config
read_EAST
touch "\${EAS_PATH}"
EAS=\$(cat "\${EAS_PATH}")
old_AS="\${AS}"
old_EAST="\${EAST}"
switch=1
RELOAD &
while true
do
	if [[ ! -f "\${DIR}/disable" ]]; then
		if [[ \${switch} = 0 ]]; then
			change_prop "重新运行"
			switch=1
			reload=1
			busybox sh "\${DIR}/Script/ASGuard_Process.sh" &
			exit
		fi
		timer_start="\$(get_time 1)"
		load_config
		while [[ \${running} = 1 ]]; do
			#标记变量，确保在此分支连续运行多次只输出一次log
			if [[ \${tip:-0} != 1 ]]; then
				mylog "模块服务开始运行..." "ASGuard"
				tip=1
			fi
			load_config
			read_EAST
			if_AS "\${AS}" "\${old_AS}" &
			if_EAST "\${EAST}" "\${old_EAST}" &
			[[ \${timemarker:=1} != 0 ]] && mark_time
			wait
			#上面更改过EAST需要再读一次
			read_EAST
			old_EAST="\${EAST}"
			old_AS="\${AS}"
			sleep "\${CTime}"
			[[ -f "\${DIR}/disable" ]] && running=0
		done
		if [[ \${tip} = 1 ]]; then
			mylog "服务已停止运行" "ASGuard"
			tip=0
		fi
	else
		if [[ \${switch} = 1 ]]; then
			change_prop "已被手动停止"
			mylog "模块服务已被手动禁用" "ASGuard"
			switch=0
		fi
		sleep \$(( \${CTime} + 6 ))
	fi
done
wait
exit 1
EOF
CONFIG="/data/media/0/Android/ASGuard.conf"
source "${DIR}/module.prop"
[[ -f "${CONFIG}" ]] || echo -e "id=huzeASGuard\nname=H-无障碍服务守护[ASGuard]\nversion=${version}\nversionCode=${versionCode}\nauthor=沍澤\ndescription=开机自动开启且实时保护无障碍服务,防止应用意外关闭导致无障碍服务连同关闭. [ASGuard.conf配置文件丢失，请重新刷入或使用ASGuardUI修改导入]" > "${DIR}/module.prop"
source "${CONFIG}"
[[ -z "${MODPATH}" ]] && echo "MODPATH=${DIR}" >> "${CONFIG}" || [[ "${MODPATH}" != "${DIR}" ]] && sed -i "s#^MODPATH=.*#MODPATH=${DIR}#g" "${CONFIG}" >/dev/null 2>&1
chmod 777 "${DIR}/Script/ASGuard_Function.sh"
chmod 777 "${DIR}/Script/ASGuard_Process.sh"
export PATH=${DIR}/busybox/bin:${PATH}
while [[ "$(ps -ef | grep 'ASGuard_Process.sh' | grep -v grep | wc -l)" = "0" ]]; do
	busybox sh "${DIR}/Script/ASGuard_Process.sh" &
	sleep 2
done
exit