#BOOTMODE（布尔）：true如果模块已安装在Magisk应用中
#MODPATH （路径）：应在其中安装模块文件的路径

timer_start=$(date "+%Y-%m-%d %H:%M:%S")

LogPrint() { echo "$1" ; }

WriteConfig() {
	cat <<EOF > /data/media/0/Android/ASGuard.conf
#面板日期：2021.09.15#作者：酷安@沍澤#QQ用户群：837934310#
#======================提示========================
#需要保护的APP包名请填在下面AS的" "内，一行一个！不要填在" "外面！否则无法正常运行！
#填在AS配置里的包名不需要填到package_Whitelist里面

AS="${AS}"

#这个是电池优化白名单列表，开机将自动加入电池优化白名单，修改此项开机时生效
#一行一个包名，填在" "内！
package_whitelist="${package_whitelist}"

#模块检测无障碍功能周期时间
CTime=${CTime:-3}

#定时刷新( 重启 )无障碍功能开关的时间，为0时为关闭，单位: 分钟
ReloadTime=${ReloadTime:-0}

#是否开启Magisk模块列表运行时间显示
#开启：1 关闭：0
timemarker=${timemarker:-1}

#是否开启开机清空电池优化白名单选项
#开启：1 关闭：0
whitelistclear=${whitelistclear:-1}

#重复写入开关，如果无障碍服务无法运行的情况出现过于频繁可尝试开启此选项
#开启：1 关闭：0
rewrite=${rewrite:-1}

#是否开启log
#开启：1 关闭：0
log=${log:-1}

#开机是否覆盖原有已开启的无障碍功能开关（开机时生效）
#开启：1 关闭：0
cover=${cover:-1}

#是否只进行开机开启无障碍功能（开机时生效）
#如果是则在开启保存的无障碍后自动结束本模块服务进程
#此开关不影响开机清空电池优化白名单进程#开启：1 关闭：0
stop=${stop:-0}

#模块目录，请不要随便修改
MODPATH=${MODPATH//_update/}

EOF
}

model="$(grep_prop ro.product.system.model)"
version="$(grep_prop version ${MODPATH}/module.prop)"
versioncode="$(grep_prop versionCode ${MODPATH}/module.prop)"
var_version="$(grep_prop ro.build.version.release)"
name="$(grep_prop name ${MODPATH}/module.prop)"
description="$(grep_prop description ${MODPATH}/module.prop)"
cat <<EOF
- **********该设备信息**********
- 您的设备名称: ${model}
- 系统版本: ${var_version}
- ********正在安装的模块********
- 名称：${name}
- 版本：${version}
- 版本号：${versioncode}
- 作者：沍澤
- ${description}
- 安装日期：${timer_start}
- **********更新日志***********
- 注意：v3.0之后的版本更改了模块id，更新须卸载v3.0以前的版本
- 卸载前请备份/Android/ASGuard.txt以防配置被删除
- （尽管此版本会移除旧版模块的删除配置文件命令）
- --------------------------------------
- v5.0(202201061)更新日志
- 修复: 一些可能存在的兼容性问题
- 优化: 部分代码
- 新增: 定时刷新 (重启) 无障碍功能开关
- 改进: 根据配置生成的代码文件
- 改进: 引用自带的busybox环境
- 已知问题：写入输入法的无障碍功能开关可能无法生效，原因我也不知道
- 
- 提示：在Magisk列表关闭模块开关可暂时停止保护服务，关机前请记得打开~
- 
- *******************************
- 
EOF

if ${BOOTMODE}; then
	if_update=1
else
	if_update=0
fi

LogPrint "- 进度(0/5)"
chmod 7777 ${MODPATH}/Script/ASGuard_Process.sh
chmod 7777 ${MODPATH}/Script/ASGuard_Function.sh

if [[ ! -f /data/media/0/Android/ASGuard.txt ]] && [[ ! -f /data/media/0/Android/ASGuard.conf ]]; then
	LogPrint "- 正在生成配置文件，请到目录/data/media/0/Android/ASGuard.conf查看修改"
	LogPrint ""
	LogPrint "-- 默认周期3秒"
	LogPrint "-- 默认关闭开机清理电池优化白名单"
	LogPrint "-- 默认开启重复写入无障碍服务开关"
	LogPrint "-- 默认开启Magisk模块列表运行时间显示"
	LogPrint "-- 默认开启log日志"
	LogPrint "-- 默认开启开机覆盖原有开启的无障碍"
	LogPrint "-- 默认关闭开机开启无障碍后结束模块进程"
	LogPrint "-- 模块安装目录${MODPATH//_update/}(如果模块目录不正确请截屏此页面并告知作者)"
	LogPrint "- 如果您需要修改以上内容可到/Android/ASGuard.conf修改或重新刷入修改"
	WriteConfig
else

	LogPrint "- 发现ASGuard配置文件"
	if [[ -f /data/media/0/Android/ASGuard.txt ]]; then
		LogPrint "- 正在转为新版配置格式并移除旧版配置"
		AS=$(sed -n p /data/media/0/Android/ASGuard.txt | sed '/^$/d')
		LogPrint "-- 默认周期3秒"
		LogPrint "-- 默认关闭开机清理电池优化白名单"
		LogPrint "-- 默认开启重复写入无障碍服务开关"
		LogPrint "-- 默认开启Magisk模块列表运行时间显示"
		LogPrint "-- 默认开启log日志"
		LogPrint "-- 默认开启开机覆盖原有开启的无障碍"
		LogPrint "-- 默认关闭开机开启无障碍后结束模块进程"
		LogPrint "-- 模块安装目录${MODPATH//_update/}(如果模块目录不正确请截屏此页面并告知作者)"
		LogPrint "-- 如果您需要修改以上内容可到/Android/ASGuard.conf修改或重新刷入修改"
		WriteConfig
		rm -rf /data/media/0/Android/ASGuard.txt
		LogPrint "- 完成"
	else
		LogPrint "- 正在刷新配置文件..."
		TEMPPATH=${MODPATH}
		. /data/media/0/Android/ASGuard.conf
		WriteConfig
		MODPATH=${TEMPPATH}
	fi
fi
LogPrint "- 调整配置文件所属权限用户组"
chomod 664 /data/media/0/Android/ASGuard.conf
chown 'media_rw:media_rw' /data/media/0/Android/ASGuard.conf
LogPrint "- 设置完成"


LogPrint "- 进度(1/5)"
if [[ -f /data/adb/modules/huzeASP/module.prop ]]; then
	touch /data/adb/modules/huzeASP/remove
	LogPrint "- 发现旧版模块，以Magisk方式添加移除标记"
fi

LogPrint "- 进度(2/5)"
if [[ -f /data/adb/modules/huzeASP/uninstall.sh ]]; then
	rm /data/adb/modules/huzeASP/uninstall.sh
	LogPrint "- 移除旧版模块卸载配置命令完成"
fi

LogPrint "- 进度(3/5)"
if [[ -f /data/media/0/Android/EAS.txt ]]; then
	tmpEAS=$(sed "s/:/\n/g" /data/media/0/Android/EAS.txt | sort | uniq)
	echo "${tmpEAS}" > "${MODPATH//_update/}/config/EAS.ini"
	rm /data/media/0/Android/EAS.txt
	LogPrint "- 旧目录发现EAS.txt，已复制内容至模块目录"
fi

LogPrint "- 进度(4/5)"
if [[ -f "${MODPATH//_update/}/config/EAS.tx"t ]]; then
	tmpEAS=$(sed "s/:/\n/g" "${MODPATH//_update/}/config/EAS.txt" | sort | uniq)
	echo "${tmpEAS}" > "${MODPATH//_update/}/config/EAS.ini"
	LogPrint "- 发现旧EAS.txt，已复制内容至模块目录"
elif [[ -f "${MODPATH//_update/}/config/EAS.ini" ]]; then
	echo "$(sed -n p "${MODPATH//_update/}/config/EAS.ini" | sort | uniq)" > "${MODPATH}/config/EAS.ini"
	LogPrint "- 发现旧EAS.ini，已恢复内容至更新目录"
fi

LogPrint "- 进度(5/5)"
timer_end=`date "+%Y-%m-%d %H:%M:%S"`
duration=`echo $(($(date +%s -d "${timer_end}") - $(date +%s -d "${timer_start}"))) | awk '{t=split("60 s 60 m 24 h 999 d",a);for(n=1;n<t;n+=2){if($1==0)break;s=$1%a[n]a[n+1]s;$1=int($1/a[n])}print s}'`
[[ -z ${duration} ]] || [[ ${duration} = "1s" ]] && duration="秒刷！"
if [[ ${if_update} = 1 ]]; then
	LogPrint "- 更新完成，耗时：${duration}"
else
	LogPrint "- 安装完成，耗时：${duration}"
fi
LogPrint "- 重启设备后生效(安装ASGuardUI可免重启更新)"
