ui_print " "

# information
MODVER=`grep_prop version $MODPATH/module.prop`
MODVERCODE=`grep_prop versionCode $MODPATH/module.prop`
ui_print " ID=$MODID"
ui_print " Version=$MODVER"
ui_print " VersionCode=$MODVERCODE"
ui_print " MagiskVersion=$MAGISK_VER"
ui_print " MagiskVersionCode=$MAGISK_VER_CODE"
ui_print " "

# mount
if [ "$BOOTMODE" != true ]; then
  mount -o rw -t auto /dev/block/bootdevice/by-name/persist /persist
  mount -o rw -t auto /dev/block/bootdevice/by-name/metadata /metadata
fi

# function
remove_module() {
for MODULES in $MODULE; do
  FILE=/data/adb/modules/$MODULES/uninstall.sh
  if [ -f $FILE ]; then
    sh $FILE
  fi
  FILE=/data/adb/modules_update/$MODULES/uninstall.sh
  if [ -f $FILE ]; then
    sh $FILE
  fi
  rm -rf /data/adb/modules*/$MODULES
done
}

# remove module
ui_print "- Removes Dolby modules... "
MODULE="dolbyatmos
        DolbyAudio
        MotoDolby
        DolbyAtmos"
remove_module
MODULE=SoundEnhancement
FILE=/data/adb/modules/$MODULE/module.prop
if grep -Eq 'Dolby Atmos Xperia' $FILE; then
  remove_module
fi
MODULE=MiSound
FILE=/data/adb/modules/$MODULE/module.prop
if grep -Eq 'Mi Sound and Dolby Atmos' $FILE; then
  remove_module
fi
ui_print " "

# done
ui_print "- Done "
ui_print " "
ui_print "- If it gives any error, copy /cache/recovery to /sdcard & send it"
ui_print "  to the author."
rm -rf /data/adb/modules*/$MODID
exit 0




