#!/system/bin/sh
MODDIR=${0%/*}
sleep 5
# 读取配置文件
config_file="配置.txt"
# 从配置文件中读取变量
while IFS='=' read key value; do
    case "$key" in
        "黑名单位置") blacklist1="$value" ;;
        "过期黑名单位置") blacklist2="$value" ;;
        "白名单位置") whitelist="$value" ;;
        "保留天数") retain_days="$value" ;;
        "程序清理间隔秒数") wait_time="$value" ;;
    esac
done < "$config_file"
#echo  "$blacklist1" "$blacklist2" "$whitelist" "$retain_days" -s "$wait_time" 
# 检查是否所有必需的参数都已设置
if [ -z "$blacklist1" ] || [ -z "$blacklist2" ] || [ -z "$whitelist" ] || [ -z "$retain_days" ] || [ -z "$wait_time" ]; then
    echo "配置文件中缺少必要的参数。"
    exit 1
fi
./Clean-C "$blacklist1" "$blacklist2" "$whitelist" "$retain_days" -s "$wait_time" -debug off &
sh 回收.sh
exit 0