#!/system/bin/sh

# 原作者: 酷安@余空
# v1.1(210223): 添加识别: 酷安@阿巴酱 （识别是否有安装字体模块，从而创建/删除 空字体文件夹，就算没安装字体模块也可以刷入
# 且安装字体模块后默认创建启用）
# v2.0(210226): 添加自动排除部分字体模块内容导致设备卡顿问题解决: 酷安@阿巴酱
# v2.1(210227): 添加设备系统判断(MIUI12.5才能用) 防止其他系统版本刷入卡米
# v3.0(210706): 更新支持最新版本MIUI 酷安@YuKongA (余空)
# v4.0(210825): 更新修复部分字体模块英数字体无效问题/脚本优化判断 酷安@阿巴酱
# v4.1(210826): 更新一个判断(部分字体模块有 /system/fonts/MiLanProVF.ttf 文件，所以不进行创建替换。)

# 根据酷安@落霞孤鹜lxgw大佬说明
# 自动排除以下字体模块文件夹↓
#----------------------------------#
#/MiLanProVF.ttf/.replace 文件
#/MitypeClock.otf/ 文件夹
#/MitypeClockMono.otf/ 文件夹
#/MitypeMonoVF.ttf/ 文件夹
#/MitypeVF.ttf/ 文件夹
#/Miui-Bold.ttf/ 文件夹
#/Miui-Light.ttf/ 文件夹
#/Miui-Regular.ttf/ 文件夹
#/Miui-Thin.ttf/ 文件夹
#/MiuiEx-Bold.ttf/ 文件夹
#/MiuiEx-Regular.ttf/ 文件夹
#----------------------------------#

MODDIR=${0%/*}

RM() {
    rm -rf $1/MiLanProVF.ttf/.replace >/dev/null
    rm -rf $1/MitypeClock.otf/ >/dev/null
    rm -rf $1/MitypeClockMono.otf/ >/dev/null
    rm -rf $1/MitypeMonoVF.ttf/ >/dev/null
    rm -rf $1/MitypeVF.ttf/ >/dev/null
    rm -rf $1/Miui-Bold.ttf/ >/dev/null
    rm -rf $1/Miui-Light.ttf/ >/dev/null
    rm -rf $1/Miui-Regular.ttf/ >/dev/null
    rm -rf $1/Miui-Thin.ttf/ >/dev/null
    rm -rf $1/MiuiEx-Bold.ttf/ >/dev/null
    rm -rf $1/MiuiEx-Regular.ttf/ >/dev/null
}

for i in $(ls /data/adb/modules/);
do
  RM "/data/adb/modules/${i}/system/fonts"
  if [[ -f /data/adb/modules/${i}/system/etc/fonts.xml ]]; then
      if [[ ! -f /data/adb/modules/${i}/disable ]]; then
          if [[ ! -f /data/adb/modules/${i}/system/fonts/MiLanProVF.ttf ]]; then
              TestFile="0"
          else
              TestFile="1"
          fi
              DETECT="0"
      else
          if [[ ${DETECT} != 0 ]]; then
              DETECT="1"
          fi
      fi
  fi
done

if [[ ${DETECT} == 0 ]]; then
    if [[ ${TestFile} == 0 ]];then
        mkdir -p ${MODDIR}/system/fonts/MiLanProVF.ttf/
    fi
    mkdir -p ${MODDIR}/system/fonts/MiSansVF.ttf/
    cp ${MODDIR}/files/* ${MODDIR}/system/fonts/
    echo 'id=ttf
    name=空字体-自动识别
    version=v4.1(0826)
    versionCode=210826
    author=余空 & 阿巴酱
    description=解决MIUI使用字体模块失效及无法实现多字重问题.「已安装字体模块并正常开启,模块已生效」' > $MODDIR/module.prop
else
    rm -rf ${MODDIR}/system/
    echo 'id=ttf
    name=空字体-自动识别
    version=v4.1(0826)
    versionCode=210826
    author=余空 & 阿巴酱
    description=解决MIUI使用字体模块失效及无法实现多字重问题.「未安装字体模块或字体模块被禁用,模块未生效」' > $MODDIR/module.prop
fi