######################
#
# Magisk模块安装脚本
# by xiaoran
#
######################

# 调试
# ui_print() {
# echo "$1"
# }

# 调试标记
DUBUG_FLAG=false

SKIPMOUNT=false

# 是否加载 system.prop
PROPFILE=true

# 是否执行 post-fs-data 脚本
POSTFSDATA=false

# 是否执行 service 脚本
LATESTARTSERVICE=false

REPLACE=""

# 获取模块版本
module_version="`grep_prop version $TMPDIR/module.prop`"

# 获取模块名称
module_name="`grep_prop name $TMPDIR/module.prop`"

# 获取模块id
module_id="`grep_prop id $TMPDIR/module.prop`"

# 获取模块作者
module_author="`grep_prop author $TMPDIR/module.prop`"

# 介绍等(无需更改，脚本将会自动从module.prop中获取信息)
print_modname() {
  ui_print "-------------------------------------"
  ui_print "- $module_name "
  ui_print "- 作者: $module_author"
  ui_print "- 版本: $module_version"
  ui_print "-------------------------------------"
}

# 安装脚本
on_install() {
  
 

  ui_print "- 正在安装..."

  # 解压/system 文件至模块目录
  unzip -o "$ZIPFILE" 'system/*' -d $MODPATH >&2

  
  # 清除缓存
  rm -rf /data/system/package_cache/*
}

# 设置权限
set_permissions() {
  # 普通权限
  set_perm_recursive $MODPATH 0 0 0755 0644

}
