##########################################################################################
#
# Magisk 模块配置脚本示例
# by topjohnwu
# 翻译: cjybyjk
#
##########################################################################################
##########################################################################################
#
# 说明:
#
# 1. 将你的文件放入 system 文件夹 (删除 placeholder 文件)
# 2. 将模块信息写入 module.prop
# 3. 在这个文件中进行设置 (config.sh)
# 4. 如果你需要在启动时执行命令, 请把它们加入 common/post-fs-data.sh 或 common/service.sh
# 5. 如果需要修改系统属性(build.prop), 请把它加入 common/system.prop
#
##########################################################################################

##########################################################################################
# 配置
##########################################################################################

# 如果你需要启用 Magic Mount, 请把它设置为 true
# 大多数模块都需要启用它
AUTOMOUNT=true

# 如果你需要加载 system.prop, 请把它设置为 true
PROPFILE=true

# 如果你需要执行 post-fs-data 脚本, 请把它设置为 true
POSTFSDATA=true

# 如果你需要执行 service 脚本, 请把它设置为 true
LATESTARTSERVICE=true
SKIPMOUNT=false
##########################################################################################
# 安装信息
##########################################################################################

# 在这里设置你想要在模块安装过程中显示的信息

print_modname() {
  ui_print "***********************"
  ui_print "MiSoundBOOST!!!!"
  ui_print "Design By Huber_HaYu"
  ui_print "***********************"
}

##########################################################################################
# 替换列表
##########################################################################################

# 列出你想在系统中直接替换的所有目录
# 查看文档，了解更多关于Magic Mount如何工作的信息，以及你为什么需要它

# 这是个示例
REPLACE="
/system/app/Youtube
/system/priv-app/SystemUI
/system/priv-app/Settings
/system/framework
"

# 在这里构建你自己的列表，它将覆盖上面的示例
# 如果你不需要替换任何东西，!千万不要! 删除它，让它保持现在的状态
REPLACE="
/system/priv-app/MusicFX/MusicFX.apk
/system/vendor/etc/dolby/dax-default.xml
/system/etc/mixer_paths.xml
/system/etc/mixer_paths_cdp.xml
/system/vendor/etc/audio/sku_taro/audio_effects.conf
/system/vendor/etc/audio/sku_taro/audio_effects.xml
/system/vendor/etc/audio/sku_taro/audio_policy_configuration.xml
/system/vendor/etc/audio/sku_taro/mixer_paths_overlay_dynamic.xml
/system/vendor/etc/audio/sku_taro/mixer_paths_overlay_static.xml
/system/vendor/etc/audio/sku_taro/mixer_paths_waipio_cdp.xml
/system/vendor/etc/audio/sku_taro/mixer_paths_waipio_mtp.xml
/system/vendor/etc/audio/sku_taro/mixer_paths_waipio_qrd.xml
/system/vendor/etc/audio/sku_taro/resourcemanager_upd.xml
/system/vendor/etc/audio/sku_taro/resourcemanager_waipio_cdp.xml
/system/vendor/etc/audio/sku_taro/resourcemanager_waipio_mtp.xml
/system/vendor/etc/audio/sku_taro/resourcemanager_waipio_qrd.xml
/system/vendor/lib/rfsa/adsp/misound_res.bin
/system/vendor/lib/rfsa/adsp/misound_res_headphone.bin
/system/vendor/lib/rfsa/adsp/misound_res_spk.bin
/data/vendor/dolby/dax_sqlite3.db
/system/vendor/etc/acdbdata/adsp_avs_config.acdb
/system/vendor/etc/acdbdata/Tutu/Tutu_Speaker_cal.acdb
/system/vendor/lib/hw/sound_trigger.primary.kona.so
/system/vendor/lib/soundfx/libasphere.so
/system/vendor/lib/soundfx/libmisoundfx.so
/system/vendor/lib/soundfx/libqcbassboost.so
/system/vendor/lib64/hw/sound_trigger.primary.kona.so
/system/vendor/lib64/soundfx/libasphere.so
/system/vendor/lib64/soundfx/libmisoundfx.so
/system/vendor/lib64/soundfx/libqcbassboost.so
"

##########################################################################################
# 权限设置
##########################################################################################

set_permissions() {
  # 只有一些特殊文件需要特定的权限
  # 默认的权限应该适用于大多数情况

  # 下面是 set_perm 函数的一些示例:

  # set_perm_recursive  <目录>                <所有者> <用户组> <目录权限> <文件权限> <上下文> (默认值是: u:object_r:system_file:s0)
  # set_perm_recursive  $MODPATH/system/lib       0       0       0755        0644

  # set_perm  <文件名>                         <所有者> <用户组> <文件权限> <上下文> (默认值是: u:object_r:system_file:s0)
  # set_perm  $MODPATH/system/bin/app_process32   0       2000      0755       u:object_r:zygote_exec:s0
  # set_perm  $MODPATH/system/bin/dex2oat         0       2000      0755       u:object_r:dex2oat_exec:s0
  # set_perm  $MODPATH/system/lib/libart.so       0       0         0644

  # 以下是默认权限，请勿删除
  set_perm  $MODPATH/system/app/MiSound/MiSound.apk  0  0  0644
  set_perm  $MODPATH/system/priv-app/MusicFX/MusicFX.apk  0  0  0644
}

##########################################################################################
# 自定义函数
##########################################################################################

# 这个文件 (config.sh) 将被安装脚本在 util_functions.sh 之后 source 化(设置为环境变量)
# 如果你需要自定义操作, 请在这里以函数方式定义它们, 然后在 update-binary 里调用这些函数
# 不要直接向 update-binary 添加代码，因为这会让你很难将模块迁移到新的模板版本
# 尽量不要对 update-binary 文件做其他修改，尽量只在其中执行函数调用

