##########################################################################################
#
# Magisk Module Template Config Script
# by topjohnwu
#
##########################################################################################
##########################################################################################
#
# Instructions:
#
# 1. Place your files into system folder (delete the placeholder file)
# 2. Fill in your module's info into module.prop
# 3. Configure the settings in this file (config.sh)
# 4. If you need boot scripts, add them into common/post-fs-data.sh or common/service.sh
# 5. Add your additional or modified system properties into common/system.prop
#
##########################################################################################

##########################################################################################
# Configs
##########################################################################################

# Set to true if you need to enable Magic Mount
# To set this flag to true
SKIPMOUNT=false

# Set to true if you need to load system.prop
PROPFILE=true

# Set to true if you need post-fs-data script
POSTFSDATA=true

# Set to true if you need late_start service script
LATESTARTSERVICE=false

##########################################################################################
# Installation Message
##########################################################################################

# Set what you want to show when installing your mod

print_modname() {
  ui_print "          着迷于你眼睛"
  ui_print "          银河有迹可循"
  ui_print "         穿过时间的缝隙 "
  ui_print "          它依然真实地 "
  ui_print "            吸引我轨迹"
  ui_print "          这瞬眼的光景"
  ui_print "          最亲密的距离 "
  ui_print "         沿着你皮肤纹理 "
  ui_print "          走过曲折手臂 "
  ui_print "           做个梦给你  "
  ui_print "           做个梦给你"
  ui_print "        等到看你银色满际 "
  ui_print "       等到分不清季节更替"
  ui_print "           才敢说沉溺 "
  ui_print " "
  ui_print " "
  ui_print " "
  ui_print " "
  ui_print " "
  ui_print "     还要多远才能进入你的心"
  ui_print "       还要多久才能和你接近"
  ui_print "    咫尺远近却无法靠近的那个人"
  ui_print "          也等着和你相遇"
  ui_print "        环游的行星 怎么可以"
  ui_print "              拥有你"
  ui_print " "
  ui_print " "
  ui_print " "
  ui_print " "
  ui_print " "
  ui_print "      还要多远才能进入你的心"
  ui_print "       还要多久才能和你接近"
  ui_print "    咫尺远近却无法靠近的那个人"
  ui_print "       要怎么探寻 要多么幸运"
  ui_print "       才敢让你发觉你并不孤寂"
  ui_print "       当我还可以再跟你飞行"
  ui_print "       环游是无趣 至少可以"
  ui_print "              陪着你"
}

 ##########################################################################################
# Replace list
##########################################################################################

# List all directories you want to directly replace in the system
# Check the documentations for more info about how Magic Mount works, and why you need this

# This is an example
REPLACE_EXAMPLE="
/system/app/Youtube
/system/priv-app/SystemUI
/system/priv-app/Settings
/system/framework
"

# Construct your own list here, it will override the example above
# !DO NOT! remove this if you don't need to replace anything, leave it empty as it is now
REPLACE="
"

##########################################################################################
# Permissions
##########################################################################################

set_permissions() {
  # Only some special files require specific permissions
  # The default permissions should be good enough for most cases

  # Here are some examples for the set_perm functions:

  # set_perm_recursive  <dirname>                <owner> <group> <dirpermission> <filepermission> <contexts> (default: u:object_r:system_file:s0)
  # set_perm_recursive  $MODPATH/system/lib       0       0       0755            0644

  # set_perm  <filename>                         <owner> <group> <permission> <contexts> (default: u:object_r:system_file:s0)
  # set_perm  $MODPATH/system/bin/app_process32   0       2000    0755         u:object_r:zygote_exec:s0
  # set_perm  $MODPATH/system/bin/dex2oat         0       2000    0755         u:object_r:dex2oat_exec:s0
  # set_perm  $MODPATH/system/lib/libart.so       0       0       0644

  # The following is default permissions, DO NOT remove
  set_perm_recursive  $MODPATH  0  0  0755  0644
}

##########################################################################################
# Custom Functions
##########################################################################################

# This file (config.sh) will be sourced by the main flash script after util_functions.sh
# If you need custom logic, please add them here as functions, and call these functions in
# update-binary. Refrain from adding code directly into update-binary, as it will make it
# difficult for you to migrate your modules to newer template versions.xin
# Make update-binary as clean as possible, try to only do function calls in it.jie