#BOOTMODE（布尔）：true如果模块已安装在Magisk应用中
#MODPATH （路径）：应在其中安装模块文件的路径
LogPrint() { echo "$1" ; }

if [[ -z "$(settings get system dc_back_light)" ]] || [[ -z $(settings get system screen_brightness_float) ]]; then
	abort "您的设备不符合模块运行要求"
	exit
fi
MIUI=$(getprop ro.miui.ui.version.name)
if [[ -z ${MIUI} ]]; then
	echo "您的设备并非为MIUI，模块可能会导致您的设备失效，刷入后则默认设备出现问题责任自行承担，如不能接受请在关机前立刻卸载模块"
else
	echo "已在小米12x安卓12MIUI13.0.5上通过测试，其余版本请自测"
fi
model="$(grep_prop ro.product.system.model)"
version="$(grep_prop version ${MODPATH}/module.prop)"
versioncode="$(grep_prop versionCode ${MODPATH}/module.prop)"
var_version="$(grep_prop ro.build.version.release)"
name="$(grep_prop name ${MODPATH}/module.prop)"
description="$(grep_prop description ${MODPATH}/module.prop)"

cat <<EOF
- **********该设备信息**********
- 您的设备名称: ${model}
- 系统版本: ${var_version}
- ********正在安装的模块********
- 名称：${name}
- 版本：${version}
- 版本号：${versioncode}
- 作者：沍澤/米师傅
- ${description}
- 安装日期：$(date "+%Y.%m.%d %H:%M:%S")
EOF
